/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.webauthn;

import com.webauthn4j.data.SignatureAlgorithm;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.ECCUnique;
import com.webauthn4j.data.attestation.statement.TPMAObject;
import com.webauthn4j.data.attestation.statement.TPMAttestationStatement;
import com.webauthn4j.data.attestation.statement.TPMEccCurve;
import com.webauthn4j.data.attestation.statement.TPMGenerated;
import com.webauthn4j.data.attestation.statement.TPMIAlgHash;
import com.webauthn4j.data.attestation.statement.TPMIAlgPublic;
import com.webauthn4j.data.attestation.statement.TPMISTAttest;
import com.webauthn4j.data.attestation.statement.TPMSAttest;
import com.webauthn4j.data.attestation.statement.TPMSCertifyInfo;
import com.webauthn4j.data.attestation.statement.TPMSClockInfo;
import com.webauthn4j.data.attestation.statement.TPMSECCParms;
import com.webauthn4j.data.attestation.statement.TPMTHA;
import com.webauthn4j.data.attestation.statement.TPMTPublic;
import com.webauthn4j.data.attestation.statement.TPMUAttest;
import com.webauthn4j.test.AttestationCertificateBuilder;
import com.webauthn4j.test.TestDataUtil;
import com.webauthn4j.test.authenticator.webauthn.AttestationOption;
import com.webauthn4j.test.authenticator.webauthn.AttestationStatementRequest;
import com.webauthn4j.test.authenticator.webauthn.TPMAttestationOption;
import com.webauthn4j.test.authenticator.webauthn.WebAuthnModelAuthenticator;
import com.webauthn4j.test.authenticator.webauthn.exception.WebAuthnModelException;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.util.MessageDigestUtil;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class TPMAuthenticator
extends WebAuthnModelAuthenticator {
    @Override
    public AttestationStatement createAttestationStatement(AttestationStatementRequest attestationStatementRequest, RegistrationEmulationOption registrationEmulationOption) {
        COSEAlgorithmIdentifier alg = COSEAlgorithmIdentifier.ES256;
        TPMTPublic pubArea = this.createTPMTPublic(attestationStatementRequest.getCredentialKeyPair().getPublic());
        TPMSAttest certInfo = this.createTPMSAttest(attestationStatementRequest, alg, pubArea);
        byte[] signature = registrationEmulationOption.isSignatureOverrideEnabled() ? registrationEmulationOption.getSignature() : TestDataUtil.calculateSignature(this.getAttestationKeyPair().getPrivate(), certInfo.getBytes());
        AttestationOption attestationOption = registrationEmulationOption.getAttestationOption() == null ? new TPMAttestationOption() : registrationEmulationOption.getAttestationOption();
        AttestationCertificatePath attestationCertificatePath = new AttestationCertificatePath(this.getAttestationCertificate(attestationStatementRequest, attestationOption), (List)this.getCACertificatePath());
        return new TPMAttestationStatement(alg, attestationCertificatePath, signature, certInfo, pubArea);
    }

    @Override
    public X509Certificate createAttestationCertificate(AttestationStatementRequest attestationStatementRequest, AttestationOption attestationOption) {
        TPMAttestationOption tpmAttestationOption;
        AttestationCertificateBuilder builder = new AttestationCertificateBuilder(this.getAttestationIssuerCertificate(), new X500Principal(attestationOption.getSubjectDN()), this.getAttestationKeyPair().getPublic());
        builder.addSubjectAlternativeNamesExtension("2.23.133.2.3=#0c0b69643a3030303230303030,2.23.133.2.2=#0c03535054,2.23.133.2.1=#0c0b69643a3439344535343433");
        if (attestationOption.isCAFlagInBasicConstraints()) {
            builder.addBasicConstraintsExtension();
        }
        if (attestationOption instanceof TPMAttestationOption && (tpmAttestationOption = (TPMAttestationOption)attestationOption).isTcgKpAIKCertificateFlagInExtendedKeyUsage()) {
            builder.addExtendedKeyUsageExtension(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier("2.23.133.8.3")));
        }
        return builder.build(this.getAttestationIssuerPrivateKey());
    }

    public X509Certificate createAttestationCertificate(AttestationStatementRequest attestationStatementRequest) {
        return this.createAttestationCertificate(attestationStatementRequest, new TPMAttestationOption());
    }

    private TPMSAttest createTPMSAttest(AttestationStatementRequest attestationStatementRequest, COSEAlgorithmIdentifier alg, TPMTPublic pubArea) {
        MessageDigest messageDigest;
        TPMGenerated magic = TPMGenerated.TPM_GENERATED_VALUE;
        TPMISTAttest type = TPMISTAttest.TPM_ST_ATTEST_CERTIFY;
        byte[] qualifiedSigner = Base64UrlUtil.decode((String)"AAu8WfTf2aakLcO4Zq_y3w0Zgmu_AUtnqwrW67F2MGuABw");
        try {
            SignatureAlgorithm signatureAlgorithm = alg.toSignatureAlgorithm();
            messageDigest = signatureAlgorithm.getMessageDigestAlgorithm().createMessageDigestObject();
        }
        catch (IllegalArgumentException e) {
            throw new WebAuthnModelException("alg is not signature algorithm", e);
        }
        byte[] extraData = messageDigest.digest(attestationStatementRequest.getSignedData());
        BigInteger clock = BigInteger.valueOf(7270451399L);
        long resetCount = 1749088739L;
        long restartCount = 3639844613L;
        TPMSClockInfo clockInfo = new TPMSClockInfo(clock, resetCount, restartCount, true);
        BigInteger firmwareVersion = new BigInteger("12241000001210926099");
        byte[] nameDigest = MessageDigestUtil.createSHA256().digest(pubArea.getBytes());
        TPMTHA name = new TPMTHA(TPMIAlgHash.TPM_ALG_SHA256, nameDigest);
        byte[] qualifiedNameDigest = Base64UrlUtil.decode((String)"AVI0eQ_AAZjNvrhUEMK2q4wxuwIFOnHIDF0Qljhf47Q");
        TPMTHA qualifiedName = new TPMTHA(TPMIAlgHash.TPM_ALG_SHA256, qualifiedNameDigest);
        TPMSCertifyInfo attested = new TPMSCertifyInfo(name, qualifiedName);
        return new TPMSAttest(magic, type, qualifiedSigner, extraData, clockInfo, firmwareVersion, (TPMUAttest)attested);
    }

    private TPMTPublic createTPMTPublic(PublicKey credentialPublicKey) {
        TPMIAlgPublic type = null;
        TPMIAlgHash nameAlg = TPMIAlgHash.TPM_ALG_SHA256;
        TPMAObject objectAttributes = new TPMAObject(394354);
        byte[] authPolicy = Base64UrlUtil.decode((String)"nf_L82w4OuaZ-5ho3G3LidcVOIS-KAOSLBJBWL-tIq4");
        ECCUnique unique = null;
        TPMSECCParms parameters = null;
        if (credentialPublicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)credentialPublicKey;
            EllipticCurve curve = ecPublicKey.getParams().getCurve();
            parameters = new TPMSECCParms(new byte[2], new byte[2], TPMEccCurve.create((EllipticCurve)curve), new byte[2]);
            type = TPMIAlgPublic.TPM_ALG_ECDSA;
            ECPoint ecPoint = ecPublicKey.getW();
            byte[] x = ecPoint.getAffineX().toByteArray();
            byte[] y = ecPoint.getAffineY().toByteArray();
            unique = new ECCUnique(x, y);
        }
        return new TPMTPublic(type, nameAlg, objectAttributes, authPolicy, parameters, unique);
    }
}

