/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.metadata;

import com.webauthn4j.metadata.HttpClient;
import com.webauthn4j.metadata.exception.MDSException;
import java.io.IOException;
import java.util.Objects;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class RestTemplateAdaptorHttpClient
implements HttpClient {
    private final RestTemplate restTemplate;

    public RestTemplateAdaptorHttpClient(RestTemplate restTemplate) {
        Assert.notNull((Object)restTemplate, (String)"restTemplate must not be null");
        this.restTemplate = restTemplate;
    }

    public HttpClient.Response fetch(String url) {
        ResponseEntity entity = this.restTemplate.getForEntity(url, Resource.class, new Object[0]);
        Resource resource = Objects.requireNonNull((Resource)entity.getBody());
        try {
            return new HttpClient.Response(entity.getStatusCode().value(), resource.getInputStream());
        }
        catch (IOException e) {
            throw new MDSException("Failed to fetch " + url, (Throwable)e);
        }
    }
}

