/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.util.internal;

import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.springframework.security.exception.BadAttestationStatementException;
import com.webauthn4j.springframework.security.exception.BadOriginException;
import com.webauthn4j.springframework.security.exception.BadRpIdException;
import com.webauthn4j.springframework.security.exception.BadStatusException;
import com.webauthn4j.springframework.security.exception.ConstraintViolationException;
import com.webauthn4j.springframework.security.exception.KeyDescriptionValidationException;
import com.webauthn4j.springframework.security.exception.MaliciousCounterValueException;
import com.webauthn4j.springframework.security.exception.TrustAnchorNotFoundException;
import com.webauthn4j.springframework.security.exception.UnexpectedExtensionException;
import com.webauthn4j.springframework.security.exception.UserNotVerifiedException;
import com.webauthn4j.springframework.security.exception.ValidationException;
import com.webauthn4j.util.exception.WebAuthnException;
import com.webauthn4j.verifier.exception.BadAaguidException;
import com.webauthn4j.verifier.exception.BadAlgorithmException;
import com.webauthn4j.verifier.exception.BadChallengeException;
import com.webauthn4j.verifier.exception.BadSignatureException;
import com.webauthn4j.verifier.exception.CertificateException;
import com.webauthn4j.verifier.exception.InconsistentClientDataTypeException;
import com.webauthn4j.verifier.exception.MissingChallengeException;
import com.webauthn4j.verifier.exception.PublicKeyMismatchException;
import com.webauthn4j.verifier.exception.SelfAttestationProhibitedException;
import com.webauthn4j.verifier.exception.TokenBindingException;
import com.webauthn4j.verifier.exception.UserNotPresentException;
import com.webauthn4j.verifier.exception.VerificationException;
import org.springframework.security.authentication.AuthenticationServiceException;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static RuntimeException wrapWithAuthenticationException(WebAuthnException e) {
        if (e instanceof BadAaguidException) {
            return new com.webauthn4j.springframework.security.exception.BadAaguidException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof BadAlgorithmException) {
            return new com.webauthn4j.springframework.security.exception.BadAlgorithmException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.verifier.exception.BadAttestationStatementException) {
            if (e instanceof com.webauthn4j.verifier.exception.KeyDescriptionValidationException) {
                return new KeyDescriptionValidationException(e.getMessage(), (Throwable)e);
            }
            return new BadAttestationStatementException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof BadChallengeException) {
            return new com.webauthn4j.springframework.security.exception.BadChallengeException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.verifier.exception.BadOriginException) {
            return new BadOriginException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.verifier.exception.BadRpIdException) {
            return new BadRpIdException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof BadSignatureException) {
            return new com.webauthn4j.springframework.security.exception.BadSignatureException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.metadata.exception.BadStatusException) {
            return new BadStatusException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof CertificateException) {
            return new com.webauthn4j.springframework.security.exception.CertificateException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.verifier.exception.ConstraintViolationException) {
            return new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.verifier.exception.MaliciousCounterValueException) {
            return new MaliciousCounterValueException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof InconsistentClientDataTypeException) {
            return new com.webauthn4j.springframework.security.exception.InconsistentClientDataTypeException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof MissingChallengeException) {
            return new com.webauthn4j.springframework.security.exception.MissingChallengeException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof PublicKeyMismatchException) {
            return new com.webauthn4j.springframework.security.exception.PublicKeyMismatchException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof SelfAttestationProhibitedException) {
            return new com.webauthn4j.springframework.security.exception.SelfAttestationProhibitedException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof TokenBindingException) {
            return new com.webauthn4j.springframework.security.exception.TokenBindingException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.verifier.exception.TrustAnchorNotFoundException) {
            return new TrustAnchorNotFoundException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.verifier.exception.UnexpectedExtensionException) {
            return new UnexpectedExtensionException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof UserNotPresentException) {
            return new com.webauthn4j.springframework.security.exception.UserNotPresentException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof com.webauthn4j.verifier.exception.UserNotVerifiedException) {
            return new UserNotVerifiedException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof VerificationException) {
            return new ValidationException("WebAuthn validation error", (Throwable)e);
        }
        if (e instanceof DataConversionException) {
            return new com.webauthn4j.springframework.security.exception.DataConversionException("WebAuthn data conversion error", (Throwable)e);
        }
        return new AuthenticationServiceException(null, (Throwable)e);
    }
}

