/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.options;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.PublicKeyCredentialDescriptor;
import com.webauthn4j.data.UserVerificationRequirement;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class AssertionOptions
implements Serializable {
    private final Challenge challenge;
    private final Long timeout;
    private final String rpId;
    private final List<PublicKeyCredentialDescriptor> allowCredentials;
    private final UserVerificationRequirement userVerification;
    private final AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> extensions;

    @JsonCreator
    public AssertionOptions(@JsonProperty(value="challenge") Challenge challenge, @JsonProperty(value="timeout") Long timeout, @JsonProperty(value="rpId") String rpId, @JsonProperty(value="allowCredentials") List<PublicKeyCredentialDescriptor> allowCredentials, @JsonProperty(value="userVerification") UserVerificationRequirement userVerification, @JsonProperty(value="extensions") AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> extensions) {
        this.challenge = challenge;
        this.timeout = timeout;
        this.rpId = rpId;
        this.allowCredentials = CollectionUtil.unmodifiableList(allowCredentials);
        this.userVerification = userVerification;
        this.extensions = extensions;
    }

    public Challenge getChallenge() {
        return this.challenge;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public String getRpId() {
        return this.rpId;
    }

    public List<PublicKeyCredentialDescriptor> getAllowCredentials() {
        return this.allowCredentials;
    }

    public UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    public AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssertionOptions that = (AssertionOptions)o;
        return Objects.equals(this.timeout, that.timeout) && Objects.equals(this.challenge, that.challenge) && Objects.equals(this.rpId, that.rpId) && Objects.equals(this.allowCredentials, that.allowCredentials) && this.userVerification == that.userVerification && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.challenge, this.timeout, this.rpId, this.allowCredentials, this.userVerification, this.extensions);
    }
}

