/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.credential;

import com.webauthn4j.credential.CredentialRecordImpl;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.springframework.security.credential.WebAuthnCredentialRecord;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

public class WebAuthnCredentialRecordImpl
extends CredentialRecordImpl
implements WebAuthnCredentialRecord {
    private String name;
    private Serializable userPrincipal;

    public WebAuthnCredentialRecordImpl(String name, Serializable userPrincipal, AttestationObject attestationObject, CollectedClientData clientData, AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, Set<AuthenticatorTransport> transports) {
        super(attestationObject, clientData, clientExtensions, transports);
        this.name = name;
        this.userPrincipal = userPrincipal;
    }

    public WebAuthnCredentialRecordImpl(String name, Serializable userPrincipal, AttestationStatement attestationStatement, Boolean uvInitialized, Boolean backupEligible, Boolean backupState, long counter, AttestedCredentialData attestedCredentialData, AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticatorExtensions, CollectedClientData clientData, AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, Set<AuthenticatorTransport> transports) {
        super(attestationStatement, uvInitialized, backupEligible, backupState, counter, attestedCredentialData, authenticatorExtensions, clientData, clientExtensions, transports);
        this.name = name;
        this.userPrincipal = userPrincipal;
    }

    public WebAuthnCredentialRecordImpl(String name, Serializable userPrincipal, AttestedCredentialData attestedCredentialData, AttestationStatement attestationStatement, long counter, Set<AuthenticatorTransport> transports, AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticatorExtensions) {
        super(attestationStatement, null, null, null, counter, attestedCredentialData, authenticatorExtensions, null, clientExtensions, transports);
        this.setName(name);
        this.userPrincipal = userPrincipal;
    }

    public WebAuthnCredentialRecordImpl(String name, Serializable userPrincipal, AttestedCredentialData attestedCredentialData, AttestationStatement attestationStatement, long counter) {
        this(name, userPrincipal, attestedCredentialData, attestationStatement, counter, null, null, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Serializable getUserPrincipal() {
        return this.userPrincipal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebAuthnCredentialRecordImpl that = (WebAuthnCredentialRecordImpl)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }
}

