/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.options;

import com.webauthn4j.data.AttestationConveyancePreference;
import com.webauthn4j.data.AuthenticatorSelectionCriteria;
import com.webauthn4j.data.PublicKeyCredentialDescriptor;
import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.data.PublicKeyCredentialRpEntity;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.data.PublicKeyCredentialUserEntity;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.springframework.security.challenge.ChallengeRepository;
import com.webauthn4j.springframework.security.credential.WebAuthnCredentialRecordService;
import com.webauthn4j.springframework.security.exception.PrincipalNotFoundException;
import com.webauthn4j.springframework.security.extension.AuthenticationExtensionsClientInputsProvider;
import com.webauthn4j.springframework.security.options.AttestationOptions;
import com.webauthn4j.springframework.security.options.AttestationOptionsProvider;
import com.webauthn4j.springframework.security.options.PublicKeyCredentialUserEntityProvider;
import com.webauthn4j.springframework.security.options.RpIdProvider;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class AttestationOptionsProviderImpl
implements AttestationOptionsProvider {
    private String rpId = null;
    private String rpName = null;
    private List<PublicKeyCredentialParameters> pubKeyCredParams = new ArrayList<PublicKeyCredentialParameters>();
    private AuthenticatorSelectionCriteria registrationAuthenticatorSelection;
    private AttestationConveyancePreference attestation;
    private Long registrationTimeout = null;
    private AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> registrationExtensions;
    private RpIdProvider rpIdProvider;
    private PublicKeyCredentialUserEntityProvider publicKeyCredentialUserEntityProvider = new DefaultPublicKeyCredentialUserEntityProvider();
    private final WebAuthnCredentialRecordService webAuthnCredentialRecordService;
    private final ChallengeRepository challengeRepository;
    private AuthenticationExtensionsClientInputsProvider<RegistrationExtensionClientInput> registrationExtensionsProvider = new DefaultRegistrationExtensionsProvider();

    public AttestationOptionsProviderImpl(RpIdProvider rpIdProvider, WebAuthnCredentialRecordService webAuthnCredentialRecordService, ChallengeRepository challengeRepository) {
        Assert.notNull((Object)webAuthnCredentialRecordService, (String)"webAuthnCredentialRecordService must not be null");
        Assert.notNull((Object)challengeRepository, (String)"challengeRepository must not be null");
        this.rpIdProvider = rpIdProvider;
        this.webAuthnCredentialRecordService = webAuthnCredentialRecordService;
        this.challengeRepository = challengeRepository;
    }

    public AttestationOptionsProviderImpl(WebAuthnCredentialRecordService webAuthnCredentialRecordService, ChallengeRepository challengeRepository) {
        this(null, webAuthnCredentialRecordService, challengeRepository);
    }

    @Override
    public AttestationOptions getAttestationOptions(HttpServletRequest request, Authentication authentication) {
        PublicKeyCredentialUserEntity user;
        PublicKeyCredentialRpEntity relyingParty = new PublicKeyCredentialRpEntity(this.getRpId(request), this.rpName);
        try {
            user = this.getPublicKeyCredentialUserEntityProvider().provide(authentication);
        }
        catch (PrincipalNotFoundException e) {
            user = null;
        }
        return new AttestationOptions(relyingParty, user, this.getChallengeRepository().loadOrGenerateChallenge(request), this.getPubKeyCredParams(), this.getRegistrationTimeout(), this.getCredentials(authentication), this.getRegistrationAuthenticatorSelection(), this.getAttestation(), this.getRegistrationExtensionsProvider().provide(request));
    }

    public String getRpId() {
        return this.rpId;
    }

    public void setRpId(String rpId) {
        this.rpId = rpId;
        this.rpIdProvider = null;
    }

    public String getRpName() {
        return this.rpName;
    }

    public void setRpName(String rpName) {
        Assert.hasText((String)rpName, (String)"rpName parameter must not be empty or null");
        this.rpName = rpName;
    }

    public List<PublicKeyCredentialParameters> getPubKeyCredParams() {
        return this.pubKeyCredParams;
    }

    public void setPubKeyCredParams(List<PublicKeyCredentialParameters> pubKeyCredParams) {
        this.pubKeyCredParams = pubKeyCredParams;
    }

    public AuthenticatorSelectionCriteria getRegistrationAuthenticatorSelection() {
        return this.registrationAuthenticatorSelection;
    }

    public void setRegistrationAuthenticatorSelection(AuthenticatorSelectionCriteria registrationAuthenticatorSelection) {
        this.registrationAuthenticatorSelection = registrationAuthenticatorSelection;
    }

    public AttestationConveyancePreference getAttestation() {
        return this.attestation;
    }

    public void setAttestation(AttestationConveyancePreference attestation) {
        this.attestation = attestation;
    }

    public Long getRegistrationTimeout() {
        return this.registrationTimeout;
    }

    public void setRegistrationTimeout(Long registrationTimeout) {
        Assert.notNull((Object)registrationTimeout, (String)"registrationTimeout must not be null.");
        Assert.isTrue((registrationTimeout >= 0L ? 1 : 0) != 0, (String)"registrationTimeout must be within unsigned long.");
        this.registrationTimeout = registrationTimeout;
    }

    public AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> getRegistrationExtensions() {
        return this.registrationExtensions;
    }

    public void setRegistrationExtensions(AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> registrationExtensions) {
        this.registrationExtensions = registrationExtensions;
    }

    public RpIdProvider getRpIdProvider() {
        return this.rpIdProvider;
    }

    public void setRpIdProvider(RpIdProvider rpIdProvider) {
        this.rpId = null;
        this.rpIdProvider = rpIdProvider;
    }

    public AuthenticationExtensionsClientInputsProvider<RegistrationExtensionClientInput> getRegistrationExtensionsProvider() {
        return this.registrationExtensionsProvider;
    }

    public void setRegistrationExtensionsProvider(AuthenticationExtensionsClientInputsProvider<RegistrationExtensionClientInput> registrationExtensionsProvider) {
        Assert.notNull(registrationExtensionsProvider, (String)"registrationExtensionsProvider must not be null");
        this.registrationExtensionsProvider = registrationExtensionsProvider;
    }

    public WebAuthnCredentialRecordService getWebAuthnCredentialRecordService() {
        return this.webAuthnCredentialRecordService;
    }

    public void setPublicKeyCredentialUserEntityProvider(PublicKeyCredentialUserEntityProvider publicKeyCredentialUserEntityProvider) {
        Assert.notNull((Object)publicKeyCredentialUserEntityProvider, (String)"webAuthnUserHandleProvider must not be null");
        this.publicKeyCredentialUserEntityProvider = publicKeyCredentialUserEntityProvider;
    }

    public PublicKeyCredentialUserEntityProvider getPublicKeyCredentialUserEntityProvider() {
        return this.publicKeyCredentialUserEntityProvider;
    }

    protected ChallengeRepository getChallengeRepository() {
        return this.challengeRepository;
    }

    protected List<PublicKeyCredentialDescriptor> getCredentials(Authentication authentication) {
        if (authentication == null) {
            return Collections.emptyList();
        }
        try {
            return this.getWebAuthnCredentialRecordService().loadCredentialRecordsByUserPrincipal(authentication.getName()).stream().map(credentialRecord -> new PublicKeyCredentialDescriptor(PublicKeyCredentialType.PUBLIC_KEY, credentialRecord.getAttestedCredentialData().getCredentialId(), credentialRecord.getTransports())).collect(Collectors.toList());
        }
        catch (PrincipalNotFoundException e) {
            return Collections.emptyList();
        }
    }

    String getRpId(HttpServletRequest request) {
        if (this.rpIdProvider != null) {
            return this.rpIdProvider.provide(request);
        }
        return this.rpId;
    }

    static class DefaultPublicKeyCredentialUserEntityProvider
    implements PublicKeyCredentialUserEntityProvider {
        DefaultPublicKeyCredentialUserEntityProvider() {
        }

        @Override
        public PublicKeyCredentialUserEntity provide(Authentication authentication) {
            if (authentication == null) {
                return null;
            }
            String username = authentication.getName();
            return new PublicKeyCredentialUserEntity(username.getBytes(StandardCharsets.UTF_8), username, username);
        }
    }

    class DefaultRegistrationExtensionsProvider
    implements AuthenticationExtensionsClientInputsProvider<RegistrationExtensionClientInput> {
        DefaultRegistrationExtensionsProvider() {
        }

        @Override
        public AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> provide(HttpServletRequest httpServletRequest) {
            return AttestationOptionsProviderImpl.this.registrationExtensions;
        }
    }
}

