/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security;

import com.webauthn4j.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class WebAuthnAuthenticationRequest
implements Serializable {
    private final byte[] credentialId;
    private final byte[] clientDataJSON;
    private final byte[] authenticatorData;
    private final byte[] signature;
    private final String clientExtensionsJSON;

    public WebAuthnAuthenticationRequest(byte[] credentialId, byte[] clientDataJSON, byte[] authenticatorData, byte[] signature, String clientExtensionsJSON) {
        this.credentialId = ArrayUtil.clone((byte[])credentialId);
        this.clientDataJSON = ArrayUtil.clone((byte[])clientDataJSON);
        this.authenticatorData = ArrayUtil.clone((byte[])authenticatorData);
        this.signature = ArrayUtil.clone((byte[])signature);
        this.clientExtensionsJSON = clientExtensionsJSON;
    }

    public byte[] getCredentialId() {
        return ArrayUtil.clone((byte[])this.credentialId);
    }

    public byte[] getClientDataJSON() {
        return ArrayUtil.clone((byte[])this.clientDataJSON);
    }

    public byte[] getAuthenticatorData() {
        return ArrayUtil.clone((byte[])this.authenticatorData);
    }

    public byte[] getSignature() {
        return ArrayUtil.clone((byte[])this.signature);
    }

    public String getClientExtensionsJSON() {
        return this.clientExtensionsJSON;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAuthnAuthenticationRequest that = (WebAuthnAuthenticationRequest)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Arrays.equals(this.clientDataJSON, that.clientDataJSON) && Arrays.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.signature, that.signature) && Objects.equals(this.clientExtensionsJSON, that.clientExtensionsJSON);
    }

    public int hashCode() {
        int result = Objects.hash(this.clientExtensionsJSON);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        result = 31 * result + Arrays.hashCode(this.clientDataJSON);
        result = 31 * result + Arrays.hashCode(this.authenticatorData);
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }
}

