/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum AttachmentHint {
    INTERNAL(1L),
    EXTERNAL(2L),
    WIRED(4L),
    WIRELESS(8L),
    NFC(16L),
    BLUETOOTH(32L),
    NETWORK(64L),
    READY(128L),
    WIFI_DIRECT(256L);

    private final long value;

    private AttachmentHint(long value) {
        this.value = value;
    }

    public static AttachmentHint create(long value) {
        if (value > 65535L || value < 0L) {
            throw new IllegalArgumentException("value '" + value + "' is out of range");
        }
        if (value == 1L) {
            return INTERNAL;
        }
        if (value == 2L) {
            return EXTERNAL;
        }
        if (value == 4L) {
            return WIRED;
        }
        if (value == 8L) {
            return WIRELESS;
        }
        if (value == 16L) {
            return NFC;
        }
        if (value == 32L) {
            return BLUETOOTH;
        }
        if (value == 64L) {
            return NETWORK;
        }
        if (value == 128L) {
            return READY;
        }
        if (value == 256L) {
            return WIFI_DIRECT;
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static AttachmentHint fromJson(long value) throws InvalidFormatException {
        try {
            return AttachmentHint.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AttachmentHint.class);
        }
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }
}

