/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.metadata.MetadataItemsProvider;
import com.webauthn4j.metadata.data.MetadataItem;
import com.webauthn4j.metadata.data.MetadataItemImpl;
import com.webauthn4j.metadata.data.statement.MetadataStatement;
import com.webauthn4j.response.attestation.authenticator.AAGUID;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonFileMetadataItemsProvider
implements MetadataItemsProvider<MetadataItem> {
    private JsonConverter jsonConverter;
    private List<Path> paths = Collections.emptyList();
    private Map<AAGUID, Set<MetadataItem>> cachedMetadataItems;

    public JsonFileMetadataItemsProvider(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    @Override
    public Map<AAGUID, Set<MetadataItem>> provide() {
        if (this.cachedMetadataItems == null) {
            this.cachedMetadataItems = this.paths.stream().map(path -> new MetadataItemImpl(this.readJsonFile((Path)path))).distinct().collect(Collectors.groupingBy(item -> this.extractAAGUID(item.getMetadataStatement()))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableSet(new HashSet((Collection)entry.getValue()))));
        }
        return this.cachedMetadataItems;
    }

    private AAGUID extractAAGUID(MetadataStatement metadataStatement) {
        switch (metadataStatement.getProtocolFamily()) {
            case "fido2": {
                return new AAGUID(metadataStatement.getAaguid());
            }
            case "u2f": {
                return AAGUID.ZERO;
            }
        }
        return AAGUID.NULL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MetadataStatement readJsonFile(Path path) {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            MetadataStatement metadataStatement = (MetadataStatement)this.jsonConverter.readValue(inputStream, MetadataStatement.class);
            return metadataStatement;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load a metadata statement json file", e);
        }
    }
}

