/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.metadata.MetadataItemsResolver;
import com.webauthn4j.metadata.data.FidoMdsMetadataItem;
import com.webauthn4j.metadata.data.MetadataItem;
import com.webauthn4j.metadata.data.statement.AttestationType;
import com.webauthn4j.response.attestation.authenticator.AAGUID;
import com.webauthn4j.response.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.WIP;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidatorBase;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import com.webauthn4j.validator.exception.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@WIP
public class MetadataItemListCertPathTrustworthinessValidator<T extends MetadataItem>
extends CertPathTrustworthinessValidatorBase {
    private MetadataItemsResolver<T> metadataItemsResolver;

    public MetadataItemListCertPathTrustworthinessValidator(MetadataItemsResolver<T> metadataItemsResolver) {
        this.metadataItemsResolver = metadataItemsResolver;
    }

    public void validate(AAGUID aaguid, CertificateBaseAttestationStatement attestationStatement) {
        boolean isSurrogate;
        Set<T> metadataItems = this.metadataItemsResolver.resolve(aaguid);
        List attestationTypes = metadataItems.stream().flatMap(item -> item.getMetadataStatement().getAttestationTypes().stream()).collect(Collectors.toList());
        boolean bl = isSurrogate = !attestationTypes.isEmpty() && attestationTypes.stream().allMatch(type -> type.equals((Object)AttestationType.ATTESTATION_BASIC_SURROGATE));
        if (isSurrogate && attestationStatement.getX5c() != null) {
            throw new BadAttestationStatementException("Although aaguid is for surrogate attestation, x5c contains certificates");
        }
        for (MetadataItem metadataItem : metadataItems) {
            if (!(metadataItem instanceof FidoMdsMetadataItem)) continue;
            FidoMdsMetadataItem fidoMdsMetadataItem = (FidoMdsMetadataItem)metadataItem;
            this.doAdditionalValidationForFidoMdsMetadataItem(fidoMdsMetadataItem);
        }
        super.validate(aaguid, attestationStatement);
    }

    private void doAdditionalValidationForFidoMdsMetadataItem(FidoMdsMetadataItem fidoMdsMetadataItem) {
        fidoMdsMetadataItem.getStatusReports().forEach(report -> {
            switch (report.getStatus()) {
                case FIDO_CERTIFIED: 
                case FIDO_CERTIFIED_L1: 
                case FIDO_CERTIFIED_L1_PLUS: 
                case FIDO_CERTIFIED_L2: 
                case FIDO_CERTIFIED_L2_PLUS: 
                case FIDO_CERTIFIED_L3: 
                case FIDO_CERTIFIED_L3_PLUS: 
                case UPDATE_AVAILABLE: 
                case NOT_FIDO_CERTIFIED: 
                case SELF_ASSERTION_SUBMITTED: {
                    return;
                }
            }
            throw new CertificateException(String.format("error response from fidoMdsMetadataItem service: %s", new Object[]{report.getStatus()}));
        });
    }

    protected Set<TrustAnchor> resolveTrustAnchors(AAGUID aaguid) {
        return this.metadataItemsResolver.resolve(aaguid).stream().flatMap(metadataItem -> metadataItem.getMetadataStatement().getAttestationRootCertificates().stream()).map(certificate -> new TrustAnchor((X509Certificate)certificate, null)).collect(Collectors.toSet());
    }
}

