/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.converter.jackson.deserializer.MetadataAAGUIDRelaxedDeserializer;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticatorGetInfo {
    @JsonProperty(value="versions")
    @NotNull
    private final List<String> versions;
    @JsonProperty(value="extensions")
    @Nullable
    private final List<String> extensions;
    @JsonProperty(value="aaguid")
    @JsonDeserialize(using=MetadataAAGUIDRelaxedDeserializer.class)
    @NotNull
    private final AAGUID aaguid;
    @JsonProperty(value="options")
    @Nullable
    private final Options options;
    @JsonProperty(value="maxMsgSize")
    @Nullable
    private final Integer maxMsgSize;
    @JsonProperty(value="pinUvAuthProtocols")
    @Nullable
    private final List<PinProtocolVersion> pinUvAuthProtocols;

    @JsonCreator
    public AuthenticatorGetInfo(@JsonProperty(value="versions") @NotNull List<String> versions, @JsonProperty(value="extensions") @Nullable List<String> extensions, @JsonProperty(value="aaguid") @NotNull AAGUID aaguid, @JsonProperty(value="options") @Nullable Options options, @JsonProperty(value="maxMsgSize") @Nullable Integer maxMsgSize, @JsonProperty(value="pinUvAuthProtocols") @Nullable List<PinProtocolVersion> pinUvAuthProtocols) {
        this.versions = versions;
        this.extensions = extensions;
        this.aaguid = aaguid;
        this.options = options;
        this.maxMsgSize = maxMsgSize;
        this.pinUvAuthProtocols = pinUvAuthProtocols;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public AAGUID getAaguid() {
        return this.aaguid;
    }

    public Options getOptions() {
        return this.options;
    }

    public Integer getMaxMsgSize() {
        return this.maxMsgSize;
    }

    public List<PinProtocolVersion> getPinUvAuthProtocols() {
        return this.pinUvAuthProtocols;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorGetInfo that = (AuthenticatorGetInfo)o;
        return this.versions.equals(that.versions) && Objects.equals(this.extensions, that.extensions) && this.aaguid.equals((Object)that.aaguid) && Objects.equals(this.options, that.options) && Objects.equals(this.maxMsgSize, that.maxMsgSize) && Objects.equals(this.pinUvAuthProtocols, that.pinUvAuthProtocols);
    }

    public int hashCode() {
        return Objects.hash(this.versions, this.extensions, this.aaguid, this.options, this.maxMsgSize, this.pinUvAuthProtocols);
    }

    public static class Options {
        @JsonProperty(value="plat")
        @Nullable
        private final PlatformOption plat;
        @JsonProperty(value="rk")
        @Nullable
        private final ResidentKeyOption rk;
        @JsonProperty(value="clientPin")
        @Nullable
        private final ClientPINOption clientPIN;
        @JsonProperty(value="up")
        @Nullable
        private final UserPresenceOption up;
        @JsonProperty(value="uv")
        @Nullable
        private final UserVerificationOption uv;
        @JsonProperty(value="uvToken")
        @Nullable
        private final UVTokenOption uvToken;
        @JsonProperty(value="config")
        @Nullable
        private final ConfigOption config;

        @JsonCreator
        public Options(@JsonProperty(value="plat") @Nullable PlatformOption plat, @JsonProperty(value="rk") @Nullable ResidentKeyOption rk, @JsonProperty(value="clientPin") @Nullable ClientPINOption clientPIN, @JsonProperty(value="up") @Nullable UserPresenceOption up, @JsonProperty(value="uv") @Nullable UserVerificationOption uv, @JsonProperty(value="uvToken") @Nullable UVTokenOption uvToken, @JsonProperty(value="config") @Nullable ConfigOption config) {
            this.plat = plat;
            this.rk = rk;
            this.clientPIN = clientPIN;
            this.up = up;
            this.uv = uv;
            this.uvToken = uvToken;
            this.config = config;
        }

        public PlatformOption getPlat() {
            return this.plat;
        }

        public ResidentKeyOption getRk() {
            return this.rk;
        }

        public ClientPINOption getClientPIN() {
            return this.clientPIN;
        }

        public UserPresenceOption getUp() {
            return this.up;
        }

        public UserVerificationOption getUv() {
            return this.uv;
        }

        public UVTokenOption getUvToken() {
            return this.uvToken;
        }

        public ConfigOption getConfig() {
            return this.config;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Options options = (Options)o;
            return Objects.equals(this.plat, options.plat) && Objects.equals(this.rk, options.rk) && Objects.equals(this.clientPIN, options.clientPIN) && Objects.equals(this.up, options.up) && Objects.equals(this.uv, options.uv) && Objects.equals(this.uvToken, options.uvToken) && Objects.equals(this.config, options.config);
        }

        public int hashCode() {
            return Objects.hash(this.plat, this.rk, this.clientPIN, this.up, this.uv, this.uvToken, this.config);
        }

        public static class PlatformOption {
            public static final PlatformOption PLATFORM = new PlatformOption(true);
            public static final PlatformOption CROSS_PLATFORM = new PlatformOption(false);
            public static final PlatformOption NULL = null;
            private final boolean value;

            @JsonCreator
            public PlatformOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PlatformOption that = (PlatformOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static class ResidentKeyOption {
            public static final ResidentKeyOption SUPPORTED = new ResidentKeyOption(true);
            public static final ResidentKeyOption NOT_SUPPORTED = new ResidentKeyOption(false);
            public static final ResidentKeyOption NULL = null;
            private final boolean value;

            @JsonCreator
            public ResidentKeyOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ResidentKeyOption that = (ResidentKeyOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static class ClientPINOption {
            public static final ClientPINOption SET = new ClientPINOption(true);
            public static final ClientPINOption NOT_SET = new ClientPINOption(false);
            public static final ClientPINOption NOT_SUPPORTED = null;
            private final boolean value;

            @JsonCreator
            public ClientPINOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ClientPINOption that = (ClientPINOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static class UserPresenceOption {
            public static final UserPresenceOption SUPPORTED = new UserPresenceOption(true);
            public static final UserPresenceOption NOT_SUPPORTED = new UserPresenceOption(false);
            public static final UserPresenceOption NULL = null;
            private final boolean value;

            @JsonCreator
            public UserPresenceOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                UserPresenceOption that = (UserPresenceOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static class UserVerificationOption {
            public static final UserVerificationOption READY = new UserVerificationOption(true);
            public static final UserVerificationOption NOT_READY = new UserVerificationOption(false);
            public static final UserVerificationOption NOT_SUPPORTED = null;
            private final boolean value;

            @JsonCreator
            public UserVerificationOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                UserVerificationOption that = (UserVerificationOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static class UVTokenOption {
            public static final UVTokenOption SUPPORTED = new UVTokenOption(true);
            public static final UVTokenOption NOT_SUPPORTED = new UVTokenOption(false);
            public static final UVTokenOption NULL = null;
            private final boolean value;

            @JsonCreator
            public UVTokenOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                UVTokenOption that = (UVTokenOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static class ConfigOption {
            public static final ConfigOption SUPPORTED = new ConfigOption(true);
            public static final ConfigOption NOT_SUPPORTED = new ConfigOption(false);
            public static final ConfigOption NULL = null;
            private final boolean value;

            @JsonCreator
            public ConfigOption(boolean value) {
                this.value = value;
            }

            public boolean getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ConfigOption that = (ConfigOption)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }
        }
    }

    public static class PinProtocolVersion {
        public static final PinProtocolVersion VERSION_1 = new PinProtocolVersion(1);
        private final int value;

        @JsonCreator
        public PinProtocolVersion(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PinProtocolVersion that = (PinProtocolVersion)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

