/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.anchor;

import com.webauthn4j.anchor.TrustAnchorRepository;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import java.security.cert.TrustAnchor;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AggregatingTrustAnchorRepository
implements TrustAnchorRepository {
    List<TrustAnchorRepository> repositories;

    public AggregatingTrustAnchorRepository(TrustAnchorRepository ... repositories) {
        this.repositories = Arrays.asList(repositories);
    }

    public Set<TrustAnchor> find(AAGUID aaguid) {
        return this.repositories.stream().flatMap(repository -> repository.find(aaguid).stream()).collect(Collectors.toSet());
    }

    public Set<TrustAnchor> find(byte[] attestationCertificateKeyIdentifier) {
        return this.repositories.stream().flatMap(repository -> repository.find(attestationCertificateKeyIdentifier).stream()).collect(Collectors.toSet());
    }
}

