/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.metadata.MetadataStatementsProvider;
import com.webauthn4j.metadata.data.statement.MetadataStatement;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LocalFilesMetadataStatementsProvider
implements MetadataStatementsProvider {
    private final ObjectConverter objectConverter;
    private final Path[] paths;

    public LocalFilesMetadataStatementsProvider(ObjectConverter objectConverter, Path ... paths) {
        this.objectConverter = objectConverter;
        this.paths = paths;
    }

    @Override
    public @NonNull List<MetadataStatement> provide() {
        return Arrays.stream(this.paths).map(path -> {
            MetadataStatement metadataStatement;
            block8: {
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    metadataStatement = (MetadataStatement)this.objectConverter.getJsonConverter().readValue(inputStream, MetadataStatement.class);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to load a MetadataStatements file", e);
                    }
                }
                inputStream.close();
            }
            return metadataStatement;
        }).collect(Collectors.toList());
    }
}

