/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.metadata.data.statement.RGBPaletteEntry;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DisplayPNGCharacteristicsDescriptor
implements Serializable {
    private final @NonNull BigInteger width;
    private final @NonNull BigInteger height;
    private final @NonNull Short bitDepth;
    private final @NonNull Short colorType;
    private final @NonNull Short compression;
    private final @NonNull Short filter;
    private final @NonNull Short interlace;
    private final @Nullable List<RGBPaletteEntry> plte;

    @JsonCreator
    public DisplayPNGCharacteristicsDescriptor(@JsonProperty(value="width") @NonNull BigInteger width, @JsonProperty(value="height") @NonNull BigInteger height, @JsonProperty(value="bitDepth") @NonNull Short bitDepth, @JsonProperty(value="colorType") @NonNull Short colorType, @JsonProperty(value="compression") @NonNull Short compression, @JsonProperty(value="filter") @NonNull Short filter, @JsonProperty(value="interlace") @NonNull Short interlace, @JsonProperty(value="plte") @Nullable List<RGBPaletteEntry> plte) {
        this.width = width;
        this.height = height;
        this.bitDepth = bitDepth;
        this.colorType = colorType;
        this.compression = compression;
        this.filter = filter;
        this.interlace = interlace;
        this.plte = CollectionUtil.unmodifiableList(plte);
    }

    public @NonNull BigInteger getWidth() {
        return this.width;
    }

    public @NonNull BigInteger getHeight() {
        return this.height;
    }

    public @NonNull Short getBitDepth() {
        return this.bitDepth;
    }

    public @NonNull Short getColorType() {
        return this.colorType;
    }

    public @NonNull Short getCompression() {
        return this.compression;
    }

    public @NonNull Short getFilter() {
        return this.filter;
    }

    public @NonNull Short getInterlace() {
        return this.interlace;
    }

    public @Nullable List<RGBPaletteEntry> getPlte() {
        return this.plte;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayPNGCharacteristicsDescriptor that = (DisplayPNGCharacteristicsDescriptor)o;
        return Objects.equals(this.width, that.width) && Objects.equals(this.height, that.height) && Objects.equals(this.bitDepth, that.bitDepth) && Objects.equals(this.colorType, that.colorType) && Objects.equals(this.compression, that.compression) && Objects.equals(this.filter, that.filter) && Objects.equals(this.interlace, that.interlace) && Objects.equals(this.plte, that.plte);
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height, this.bitDepth, this.colorType, this.compression, this.filter, this.interlace, this.plte);
    }
}

