/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.metadata.CachingMetadataBLOBProvider;
import com.webauthn4j.metadata.data.MetadataBLOB;
import com.webauthn4j.metadata.data.MetadataBLOBFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LocalFileMetadataBLOBProvider
extends CachingMetadataBLOBProvider {
    private final MetadataBLOBFactory metadataBLOBFactory;
    private final Path path;

    public LocalFileMetadataBLOBProvider(@NonNull ObjectConverter objectConverter, @NonNull Path path) {
        this.metadataBLOBFactory = new MetadataBLOBFactory(objectConverter);
        this.path = path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected @NonNull MetadataBLOB doProvide() {
        try (InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);){
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            Stream<String> lines = new BufferedReader(inputStreamReader).lines();
            String string = lines.collect(Collectors.joining());
            MetadataBLOB metadataBLOB = this.metadataBLOBFactory.parse(string);
            return metadataBLOB;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load a MetadataBLOB file", e);
        }
    }
}

