/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.toc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.webauthn4j.metadata.data.toc.AuthenticatorStatus;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.util.Objects;

public class StatusReport
implements Serializable {
    @JsonProperty
    private final AuthenticatorStatus status;
    @JsonDeserialize(using=LocalDateDeserializer.class)
    @JsonSerialize(using=LocalDateSerializer.class)
    @JsonProperty
    private final LocalDate effectiveDate;
    @JsonProperty
    private final X509Certificate certificate;
    @JsonProperty
    private final String url;

    @JsonCreator
    public StatusReport(@JsonProperty(value="status") AuthenticatorStatus status, @JsonProperty(value="effectiveDate") LocalDate effectiveDate, @JsonProperty(value="certificate") X509Certificate certificate, @JsonProperty(value="url") String url) {
        this.status = status;
        this.effectiveDate = effectiveDate;
        this.certificate = certificate;
        this.url = url;
    }

    public AuthenticatorStatus getStatus() {
        return this.status;
    }

    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusReport that = (StatusReport)o;
        return this.status == that.status && Objects.equals(this.effectiveDate, that.effectiveDate) && Objects.equals(this.certificate, that.certificate) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.effectiveDate, this.certificate, this.url});
    }
}

