/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum AuthenticationAlgorithm {
    SECP256R1_ECDSA_SHA256_RAW(1),
    SECP256R1_ECDSA_SHA256_DER(2),
    RSASSA_PSS_SHA256_RAW(3),
    RSASSA_PSS_SHA256_DER(4),
    SECP256K1_ECDSA_SHA256_RAW(5),
    SECP256K1_ECDSA_SHA256_DER(6),
    SM2_SM3_RAW(7),
    RSA_EMSA_PKCS1_SHA256_RAW(8),
    RSA_EMSA_PKCS1_SHA256_DER(9),
    RSASSA_PSS_SHA384_RAW(10),
    RSASSA_PSS_SHA512_RAW(11),
    RSASSA_PKCSV15_SHA256_RAW(12),
    RSASSA_PKCSV15_SHA384_RAW(13),
    RSASSA_PKCSV15_SHA512_RAW(14),
    RSASSA_PKCSV15_SHA1_RAW(15),
    SECP384R1_ECDSA_SHA384_RAW(16),
    SECP521R1_ECDSA_SHA512_RAW(17),
    ED25519_EDDSA_SHA256_RAW(18);

    private final int value;

    private AuthenticationAlgorithm(int value) {
        this.value = value;
    }

    public static AuthenticationAlgorithm create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException("value '" + value + "' is out of range");
        }
        switch (value) {
            case 1: {
                return SECP256R1_ECDSA_SHA256_RAW;
            }
            case 2: {
                return SECP256R1_ECDSA_SHA256_DER;
            }
            case 3: {
                return RSASSA_PSS_SHA256_RAW;
            }
            case 4: {
                return RSASSA_PSS_SHA256_DER;
            }
            case 5: {
                return SECP256K1_ECDSA_SHA256_RAW;
            }
            case 6: {
                return SECP256K1_ECDSA_SHA256_DER;
            }
            case 7: {
                return SM2_SM3_RAW;
            }
            case 8: {
                return RSA_EMSA_PKCS1_SHA256_RAW;
            }
            case 9: {
                return RSA_EMSA_PKCS1_SHA256_DER;
            }
            case 10: {
                return RSASSA_PSS_SHA384_RAW;
            }
            case 11: {
                return RSASSA_PSS_SHA512_RAW;
            }
            case 12: {
                return RSASSA_PKCSV15_SHA256_RAW;
            }
            case 13: {
                return RSASSA_PKCSV15_SHA384_RAW;
            }
            case 14: {
                return RSASSA_PKCSV15_SHA512_RAW;
            }
            case 15: {
                return RSASSA_PKCSV15_SHA1_RAW;
            }
            case 16: {
                return SECP384R1_ECDSA_SHA384_RAW;
            }
            case 17: {
                return SECP521R1_ECDSA_SHA512_RAW;
            }
            case 18: {
                return ED25519_EDDSA_SHA256_RAW;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static AuthenticationAlgorithm deserialize(int value) throws InvalidFormatException {
        try {
            return AuthenticationAlgorithm.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AuthenticationAlgorithm.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

