/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async.metadata;

import com.webauthn4j.async.metadata.MetadataBLOBAsyncProvider;
import com.webauthn4j.metadata.data.MetadataBLOB;
import java.time.LocalDate;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public abstract class CachingMetadataBLOBAsyncProvider
implements MetadataBLOBAsyncProvider {
    private MetadataBLOB cachedMetadataBLOB = null;
    private CompletableFuture<MetadataBLOB> metadataBLOBFuture = new CompletableFuture();
    private LocalDate metadataBLOBLastUpdate = null;
    private final Object metadataBLOBFutureLock = new Object();
    private final Lock metadataBLOBRefreshingLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletionStage<MetadataBLOB> provide() {
        CompletableFuture<MetadataBLOB> response;
        if (!CachingMetadataBLOBAsyncProvider.needsMetadataBLOBUpdate(this.cachedMetadataBLOB, this.metadataBLOBLastUpdate)) {
            return CompletableFuture.completedFuture(this.cachedMetadataBLOB);
        }
        Object object = this.metadataBLOBFutureLock;
        synchronized (object) {
            response = this.metadataBLOBFuture;
        }
        if (this.metadataBLOBRefreshingLock.tryLock()) {
            this.doProvide().thenAccept(metadataBLOB -> {
                this.cachedMetadataBLOB = metadataBLOB;
                this.metadataBLOBLastUpdate = LocalDate.now();
                Object object = this.metadataBLOBFutureLock;
                synchronized (object) {
                    this.metadataBLOBFuture.complete((MetadataBLOB)metadataBLOB);
                    this.metadataBLOBFuture = new CompletableFuture();
                }
            }).exceptionally(e -> {
                Object object = this.metadataBLOBFutureLock;
                synchronized (object) {
                    this.metadataBLOBFuture.completeExceptionally((Throwable)e);
                    this.metadataBLOBFuture = new CompletableFuture();
                }
                this.metadataBLOBRefreshingLock.unlock();
                return null;
            });
        }
        return response;
    }

    @NotNull
    protected abstract CompletionStage<MetadataBLOB> doProvide();

    static boolean needsMetadataBLOBUpdate(MetadataBLOB cachedMetadataBLOB, LocalDate metadataBLOBLastUpdate) {
        if (cachedMetadataBLOB == null) {
            return true;
        }
        LocalDate today = LocalDate.now();
        LocalDate nextUpdate = cachedMetadataBLOB.getPayload().getNextUpdate();
        return (nextUpdate.isBefore(today) || nextUpdate.isEqual(today)) && metadataBLOBLastUpdate.isBefore(today);
    }
}

