/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async.metadata.anchor;

import com.webauthn4j.async.anchor.TrustAnchorAsyncRepository;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import java.security.cert.TrustAnchor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class AggregatingTrustAnchorAsyncRepository
implements TrustAnchorAsyncRepository {
    List<TrustAnchorAsyncRepository> repositories;

    public AggregatingTrustAnchorAsyncRepository(TrustAnchorAsyncRepository ... repositories) {
        this.repositories = Arrays.asList(repositories);
    }

    public CompletionStage<Set<TrustAnchor>> find(AAGUID aaguid) {
        return this.repositories.stream().map(repository -> repository.find(aaguid)).reduce(CompletableFuture.completedFuture(new HashSet()), (a, b) -> a.thenCombine(b, (c, d) -> {
            c.addAll(d);
            return c;
        }));
    }

    public CompletionStage<Set<TrustAnchor>> find(byte[] attestationCertificateKeyIdentifier) {
        return this.repositories.stream().map(repository -> repository.find(attestationCertificateKeyIdentifier)).reduce(CompletableFuture.completedFuture(new HashSet()), (a, b) -> a.thenCombine(b, (c, d) -> {
            c.addAll(d);
            return c;
        }));
    }
}

