/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async.metadata.anchor;

import com.webauthn4j.async.anchor.TrustAnchorAsyncRepository;
import com.webauthn4j.async.metadata.LocalFilesMetadataStatementsAsyncProvider;
import com.webauthn4j.async.metadata.MetadataStatementsAsyncProvider;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.HexUtil;
import java.nio.file.Path;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public class MetadataStatementsBasedTrustAnchorAsyncRepository
implements TrustAnchorAsyncRepository {
    private final MetadataStatementsAsyncProvider metadataStatementsAsyncProvider;

    public MetadataStatementsBasedTrustAnchorAsyncRepository(MetadataStatementsAsyncProvider metadataStatementsAsyncProvider) {
        this.metadataStatementsAsyncProvider = metadataStatementsAsyncProvider;
    }

    public MetadataStatementsBasedTrustAnchorAsyncRepository(ObjectConverter objectConverter, Path ... paths) {
        this(new LocalFilesMetadataStatementsAsyncProvider(objectConverter, paths));
    }

    public CompletionStage<Set<TrustAnchor>> find(AAGUID aaguid) {
        return this.metadataStatementsAsyncProvider.provide().thenApply(metadataStatements -> metadataStatements.stream().filter(metadataStatement -> Objects.equals(aaguid, metadataStatement.getAaguid())).flatMap(metadataStatement -> metadataStatement.getAttestationRootCertificates().stream()).map(item -> new TrustAnchor((X509Certificate)item, null)).collect(Collectors.toSet()));
    }

    public CompletionStage<Set<TrustAnchor>> find(byte[] attestationCertificateKeyIdentifier) {
        return this.metadataStatementsAsyncProvider.provide().thenApply(metadataStatements -> metadataStatements.stream().filter(metadataStatement -> metadataStatement.getAttestationCertificateKeyIdentifiers() != null && metadataStatement.getAttestationCertificateKeyIdentifiers().stream().anyMatch(identifier -> Arrays.equals(HexUtil.decode((String)identifier), attestationCertificateKeyIdentifier))).map(metadataStatement -> new TrustAnchor((X509Certificate)metadataStatement.getAttestationRootCertificates().get(0), null)).collect(Collectors.toSet()));
    }
}

