/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async.metadata;

import com.webauthn4j.async.metadata.CachingMetadataBLOBAsyncProvider;
import com.webauthn4j.async.metadata.CertPathAsyncChecker;
import com.webauthn4j.async.metadata.HttpAsyncClient;
import com.webauthn4j.async.metadata.SimpleHttpAsyncClient;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.metadata.CertPathCheckContext;
import com.webauthn4j.metadata.data.MetadataBLOB;
import com.webauthn4j.metadata.data.MetadataBLOBFactory;
import com.webauthn4j.metadata.exception.CertPathCheckException;
import com.webauthn4j.metadata.exception.MDSException;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.parse.Asn1Parser;
import org.apache.kerby.asn1.type.Asn1GeneralString;
import org.apache.kerby.asn1.type.Asn1OctetString;
import org.jetbrains.annotations.NotNull;

public class FidoMDS3MetadataBLOBAsyncProvider
extends CachingMetadataBLOBAsyncProvider {
    public static final String DEFAULT_BLOB_ENDPOINT = "https://mds.fidoalliance.org/";
    private final MetadataBLOBFactory metadataBLOBFactory;
    private final String blobEndpoint;
    private final HttpAsyncClient httpClient;
    private final Set<TrustAnchor> trustAnchors;
    private boolean revocationCheckEnabled = true;
    private CertPathAsyncChecker certPathAsyncChecker;

    public FidoMDS3MetadataBLOBAsyncProvider(@NotNull ObjectConverter objectConverter, @NotNull String blobEndpoint, @NotNull HttpAsyncClient httpClient, @NotNull Set<TrustAnchor> trustAnchors) {
        this.metadataBLOBFactory = new MetadataBLOBFactory(objectConverter);
        this.blobEndpoint = blobEndpoint;
        this.httpClient = httpClient;
        this.trustAnchors = trustAnchors;
        this.certPathAsyncChecker = new DefaultCertPathAsyncChecker(httpClient);
    }

    public FidoMDS3MetadataBLOBAsyncProvider(@NotNull ObjectConverter objectConverter, @NotNull String blobEndpoint, @NotNull Set<TrustAnchor> trustAnchors) {
        this(objectConverter, blobEndpoint, new SimpleHttpAsyncClient(), trustAnchors);
    }

    public FidoMDS3MetadataBLOBAsyncProvider(@NotNull ObjectConverter objectConverter, @NotNull String blobEndpoint, @NotNull X509Certificate trustAnchorCertificate) {
        this(objectConverter, blobEndpoint, new SimpleHttpAsyncClient(), Collections.singleton(new TrustAnchor(trustAnchorCertificate, null)));
    }

    public FidoMDS3MetadataBLOBAsyncProvider(@NotNull ObjectConverter objectConverter, @NotNull Set<TrustAnchor> trustAnchors) {
        this(objectConverter, DEFAULT_BLOB_ENDPOINT, trustAnchors);
    }

    public FidoMDS3MetadataBLOBAsyncProvider(@NotNull ObjectConverter objectConverter, @NotNull X509Certificate trustAnchorCertificate) {
        this(objectConverter, DEFAULT_BLOB_ENDPOINT, Collections.singleton(new TrustAnchor(trustAnchorCertificate, null)));
    }

    @Override
    @NotNull
    protected CompletionStage<MetadataBLOB> doProvide() {
        return this.httpClient.fetch(this.blobEndpoint).thenApply(response -> {
            String body = FidoMDS3MetadataBLOBAsyncProvider.readAsString(response.getBody());
            return this.metadataBLOBFactory.parse(body);
        }).thenCompose(metadataBLOB -> {
            if (!metadataBLOB.isValidSignature()) {
                throw new MDSException("MetadataBLOB signature is invalid");
            }
            return this.validateCertPath((MetadataBLOB)metadataBLOB).thenApply(unused -> metadataBLOB);
        });
    }

    @NotNull
    private static String readAsString(InputStream responseBody) {
        try {
            return new String(responseBody.readAllBytes());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private CompletionStage<Void> validateCertPath(@NotNull MetadataBLOB metadataBLOB) {
        CertPath certPath = metadataBLOB.getHeader().getX5c();
        try {
            return this.certPathAsyncChecker.check(new CertPathCheckContext(certPath, this.trustAnchors, this.isRevocationCheckEnabled()));
        }
        catch (CertPathCheckException e) {
            throw new MDSException("MetadataBLOB certificate chain validation failed", (Throwable)e);
        }
    }

    public boolean isRevocationCheckEnabled() {
        return this.revocationCheckEnabled;
    }

    public void setRevocationCheckEnabled(boolean revocationCheckEnabled) {
        this.revocationCheckEnabled = revocationCheckEnabled;
    }

    public CertPathAsyncChecker getCertPathAsyncValidator() {
        return this.certPathAsyncChecker;
    }

    public void setCertPathAsyncValidator(CertPathAsyncChecker certPathAsyncChecker) {
        this.certPathAsyncChecker = certPathAsyncChecker;
    }

    private static class DefaultCertPathAsyncChecker
    implements CertPathAsyncChecker {
        private final HttpAsyncClient httpClient;

        public DefaultCertPathAsyncChecker(HttpAsyncClient httpClient) {
            this.httpClient = httpClient;
        }

        @Override
        public CompletionStage<Void> check(CertPathCheckContext context) throws MDSException {
            CertPathValidator certPathValidator = CertificateUtil.createCertPathValidator();
            PKIXParameters certPathParameters = CertificateUtil.createPKIXParameters((Set)context.getTrustAnchors());
            certPathParameters.setRevocationEnabled(false);
            try {
                certPathValidator.validate(context.getCertPath(), certPathParameters);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new CertPathCheckException("invalid algorithm parameter", (Throwable)e);
            }
            catch (CertPathValidatorException e) {
                throw new CertPathCheckException("invalid cert path", (Throwable)e);
            }
            if (context.isRevocationCheckEnabled()) {
                return this.checkCRL(context);
            }
            return CompletableFuture.completedFuture(null);
        }

        private CompletionStage<Void> checkCRL(CertPathCheckContext context) {
            ArrayList<X509Certificate> certPathToTrustAnchor = new ArrayList<X509Certificate>();
            context.getCertPath().getCertificates().forEach(cert -> certPathToTrustAnchor.add((X509Certificate)cert));
            X509Certificate last = (X509Certificate)certPathToTrustAnchor.get(certPathToTrustAnchor.size() - 1);
            TrustAnchor trustAnchor = context.getTrustAnchors().stream().filter(item -> Objects.equals(item.getTrustedCert().getSubjectX500Principal(), last.getIssuerX500Principal())).findFirst().orElseThrow();
            certPathToTrustAnchor.add(trustAnchor.getTrustedCert());
            Stream completionStageStream = context.getCertPath().getCertificates().stream().map(certificate -> {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                List<String> crlDistributionPoints = this.extractCRLDistributionPoints(x509Certificate);
                Stream crlCompletionStageStream = crlDistributionPoints.stream().map(this::fetchCRL);
                return DefaultCertPathAsyncChecker.join(crlCompletionStageStream).thenApply(crlStream -> {
                    crlStream.forEach(crl -> {
                        try {
                            X509Certificate crlIssuerCertificate = certPathToTrustAnchor.stream().filter(cert -> Objects.equals(cert.getSubjectX500Principal(), crl.getIssuerX500Principal())).findFirst().orElseThrow();
                            crl.verify(crlIssuerCertificate.getPublicKey());
                        }
                        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CRLException e) {
                            throw new CertPathCheckException("crl validation failed", (Throwable)e);
                        }
                        if (crl.isRevoked((Certificate)certificate)) {
                            throw new CertPathCheckException("Certificate is revoked");
                        }
                    });
                    return null;
                });
            });
            return DefaultCertPathAsyncChecker.join(completionStageStream).thenApply(stream -> null);
        }

        private static <T> CompletionStage<Stream<T>> join(Stream<CompletionStage<T>> completionStages) {
            List completableFutures = completionStages.map(CompletionStage::toCompletableFuture).collect(Collectors.toList());
            CompletableFuture[] array = (CompletableFuture[])completableFutures.toArray(CompletableFuture[]::new);
            CompletableFuture<Void> joinedFuture = CompletableFuture.allOf(array);
            return joinedFuture.thenApply(unused -> completableFutures.stream().map(CompletableFuture::join));
        }

        private CompletionStage<X509CRL> fetchCRL(String crlDistributionPoint) {
            try {
                URL url = new URL(crlDistributionPoint);
                if (url.getProtocol().equals("http") || url.getProtocol().equals("https")) {
                    return this.httpClient.fetch(crlDistributionPoint).thenApply(response -> {
                        if (response.getStatusCode() >= 400) {
                            throw new CertPathCheckException(String.format("Failed to fetch CRL. HTTP Status code: %d", response.getStatusCode()));
                        }
                        CertificateFactory certificateFactory = CertificateUtil.createCertificateFactory();
                        try {
                            return (X509CRL)certificateFactory.generateCRL(response.getBody());
                        }
                        catch (CRLException e) {
                            throw new CertPathCheckException((Throwable)e);
                        }
                    });
                }
                throw new CertPathCheckException("http or https is the only supported protocol to fetch CRL.");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private List<String> extractCRLDistributionPoints(X509Certificate x509Certificate) {
            try {
                byte[] extensionValue = x509Certificate.getExtensionValue("2.5.29.31");
                Asn1OctetString extensionEnvelope = new Asn1OctetString();
                extensionEnvelope.decode(extensionValue);
                byte[] extensionEnvelopeValue = (byte[])extensionEnvelope.getValue();
                Asn1Container container = (Asn1Container)Asn1Parser.parse((ByteBuffer)ByteBuffer.wrap(extensionEnvelopeValue));
                List distributionPoints = container.getChildren();
                ArrayList<String> crlDistributionPoints = new ArrayList<String>();
                for (Asn1ParseResult distributionPoint : distributionPoints) {
                    List list = ((Asn1Container)distributionPoint).getChildren();
                    if (list.size() <= 0) continue;
                    Asn1ParseResult distributionPointName = (Asn1ParseResult)list.get(0);
                    Asn1GeneralString asn1GeneralString = new Asn1GeneralString();
                    asn1GeneralString.decode(distributionPointName.readBodyBytes());
                    crlDistributionPoints.add((String)asn1GeneralString.getValue());
                }
                return Collections.unmodifiableList(crlDistributionPoints);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

