/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.attestation.authenticator.AbstractCredentialPublicKey;
import com.webauthn4j.data.attestation.authenticator.Curve;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.COSEKeyOperation;
import com.webauthn4j.data.attestation.statement.COSEKeyType;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.ECUtil;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class EC2CredentialPublicKey
extends AbstractCredentialPublicKey
implements Serializable {
    @JsonProperty(value="-1")
    private Curve curve;
    @JsonProperty(value="-2")
    private byte[] x;
    @JsonProperty(value="-3")
    private byte[] y;

    @JsonCreator
    public EC2CredentialPublicKey(@JsonProperty(value="2") byte[] keyId, @JsonProperty(value="3") COSEAlgorithmIdentifier algorithm, @JsonProperty(value="4") List<COSEKeyOperation> keyOpts, @JsonProperty(value="5") byte[] baseIV, @JsonProperty(value="-1") Curve curve, @JsonProperty(value="-2") byte[] x, @JsonProperty(value="-3") byte[] y) {
        super(keyId, algorithm, keyOpts, baseIV);
        this.curve = curve;
        this.x = x;
        this.y = y;
    }

    public static EC2CredentialPublicKey createFromUncompressedECCKey(byte[] publicKey) {
        if (publicKey.length != 65) {
            throw new IllegalArgumentException("publicKey must be 65 bytes length");
        }
        byte[] x = Arrays.copyOfRange(publicKey, 1, 33);
        byte[] y = Arrays.copyOfRange(publicKey, 33, 65);
        return new EC2CredentialPublicKey(null, COSEAlgorithmIdentifier.ES256, null, null, Curve.SECP256R1, x, y);
    }

    @Override
    public COSEKeyType getKeyType() {
        return COSEKeyType.EC2;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public byte[] getX() {
        return ArrayUtil.clone((byte[])this.x);
    }

    public byte[] getY() {
        return ArrayUtil.clone((byte[])this.y);
    }

    @JsonIgnore
    public byte[] getBytes() {
        byte format = 4;
        return ByteBuffer.allocate(1 + this.x.length + this.y.length).put(format).put(this.x).put(this.y).array();
    }

    @Override
    public PublicKey getPublicKey() {
        ECPoint ecPoint = new ECPoint(new BigInteger(1, this.getX()), new BigInteger(1, this.getY()));
        ECPublicKeySpec spec = new ECPublicKeySpec(ecPoint, this.curve.getECParameterSpec());
        return ECUtil.createPublicKey((ECPublicKeySpec)spec);
    }

    @Override
    public void validate() {
        if (this.getAlgorithm() == null) {
            throw new ConstraintViolationException("algorithm must not be null");
        }
        if (this.curve == null) {
            throw new ConstraintViolationException("curve must not be null");
        }
        if (this.x == null) {
            throw new ConstraintViolationException("x must not be null");
        }
        if (this.y == null) {
            throw new ConstraintViolationException("y must not be null");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EC2CredentialPublicKey that = (EC2CredentialPublicKey)o;
        return this.curve == that.curve && Arrays.equals(this.x, that.x) && Arrays.equals(this.y, that.y);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(new Object[]{super.hashCode(), this.curve});
        result = 31 * result + Arrays.hashCode(this.x);
        result = 31 * result + Arrays.hashCode(this.y);
        return result;
    }
}

