/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.CollectionUtil;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class RegistrationObject {
    private final CollectedClientData collectedClientData;
    private final byte[] collectedClientDataBytes;
    private final AttestationObject attestationObject;
    private final byte[] attestationObjectBytes;
    private final byte[] authenticatorDataBytes;
    private final Set<AuthenticatorTransport> transports;
    private final AuthenticationExtensionsClientOutputs<ExtensionClientOutput> clientExtensions;
    private final ServerProperty serverProperty;
    private final LocalDateTime timestamp;

    public RegistrationObject(CollectedClientData collectedClientData, byte[] collectedClientDataBytes, AttestationObject attestationObject, byte[] attestationObjectBytes, byte[] authenticatorDataBytes, Set<AuthenticatorTransport> transports, AuthenticationExtensionsClientOutputs<ExtensionClientOutput> clientExtensions, ServerProperty serverProperty) {
        this(collectedClientData, collectedClientDataBytes, attestationObject, attestationObjectBytes, authenticatorDataBytes, transports, clientExtensions, serverProperty, LocalDateTime.now(Clock.systemUTC()));
    }

    public RegistrationObject(CollectedClientData collectedClientData, byte[] collectedClientDataBytes, AttestationObject attestationObject, byte[] attestationObjectBytes, byte[] authenticatorDataBytes, Set<AuthenticatorTransport> transports, AuthenticationExtensionsClientOutputs<ExtensionClientOutput> clientExtensions, ServerProperty serverProperty, LocalDateTime timestamp) {
        this.collectedClientData = collectedClientData;
        this.collectedClientDataBytes = collectedClientDataBytes;
        this.attestationObject = attestationObject;
        this.attestationObjectBytes = attestationObjectBytes;
        this.authenticatorDataBytes = authenticatorDataBytes;
        this.transports = CollectionUtil.unmodifiableSet(transports);
        this.clientExtensions = clientExtensions;
        this.serverProperty = serverProperty;
        this.timestamp = timestamp;
    }

    public CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    public byte[] getCollectedClientDataBytes() {
        return ArrayUtil.clone((byte[])this.collectedClientDataBytes);
    }

    public AttestationObject getAttestationObject() {
        return this.attestationObject;
    }

    public byte[] getAttestationObjectBytes() {
        return ArrayUtil.clone((byte[])this.attestationObjectBytes);
    }

    public byte[] getAuthenticatorDataBytes() {
        return ArrayUtil.clone((byte[])this.authenticatorDataBytes);
    }

    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public AuthenticationExtensionsClientOutputs<ExtensionClientOutput> getClientExtensions() {
        return this.clientExtensions;
    }

    public ServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationObject that = (RegistrationObject)o;
        return Objects.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.collectedClientDataBytes, that.collectedClientDataBytes) && Objects.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.attestationObjectBytes, that.attestationObjectBytes) && Arrays.equals(this.authenticatorDataBytes, that.authenticatorDataBytes) && Objects.equals(this.transports, that.transports) && Objects.equals(this.clientExtensions, that.clientExtensions) && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        int result = Objects.hash(this.collectedClientData, this.attestationObject, this.transports, this.clientExtensions, this.serverProperty, this.timestamp);
        result = 31 * result + Arrays.hashCode(this.collectedClientDataBytes);
        result = 31 * result + Arrays.hashCode(this.attestationObjectBytes);
        result = 31 * result + Arrays.hashCode(this.authenticatorDataBytes);
        return result;
    }
}

