/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.jws;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.util.Arrays;

public enum JWAIdentifier {
    RS1("RS1", "SHA1withRSA"),
    RS256("RS256", "SHA256withRSA"),
    RS384("RS384", "SHA384withRSA"),
    RS512("RS512", "SHA512withRSA"),
    ES256("ES256", "SHA256withECDSA"),
    ES384("ES384", "SHA384withECDSA"),
    ES512("ES512", "SHA512withECDSA");

    private final String name;
    private final String jcaName;

    private JWAIdentifier(String name, String jcaName) {
        this.name = name;
        this.jcaName = jcaName;
    }

    public static JWAIdentifier create(String value) {
        if (value == null) {
            return null;
        }
        return Arrays.stream(JWAIdentifier.values()).filter(it -> it.name.equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid JWA Identifier provided: " + value));
    }

    @JsonCreator
    private static JWAIdentifier fromJson(String value) throws InvalidFormatException {
        try {
            return JWAIdentifier.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "Invalid JWA Identifier provided", (Object)value, JWAIdentifier.class);
        }
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String getJcaName() {
        return this.jcaName;
    }
}

