/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import java.io.IOException;

public class AuthenticatorDataDeserializer
extends StdDeserializer<AuthenticatorData> {
    private CborConverter cborConverter;

    public AuthenticatorDataDeserializer(CborConverter cborConverter) {
        super(AuthenticatorData.class);
        this.cborConverter = cborConverter;
    }

    public AuthenticatorData deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        byte[] value = p.getBinaryValue();
        return new AuthenticatorDataConverter(this.cborConverter).convert(value);
    }
}

