/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class COSEAlgorithmIdentifier
implements Serializable {
    public static final COSEAlgorithmIdentifier RS1 = new COSEAlgorithmIdentifier(-65535L, "SHA1withRSA", "SHA-1");
    public static final COSEAlgorithmIdentifier RS256 = new COSEAlgorithmIdentifier(-257L, "SHA256withRSA", "SHA-256");
    public static final COSEAlgorithmIdentifier RS384 = new COSEAlgorithmIdentifier(-258L, "SHA384withRSA", "SHA-384");
    public static final COSEAlgorithmIdentifier RS512 = new COSEAlgorithmIdentifier(-259L, "SHA512withRSA", "SHA-512");
    public static final COSEAlgorithmIdentifier ES256 = new COSEAlgorithmIdentifier(-7L, "SHA256withECDSA", "SHA-256");
    public static final COSEAlgorithmIdentifier ES384 = new COSEAlgorithmIdentifier(-35L, "SHA384withECDSA", "SHA-384");
    public static final COSEAlgorithmIdentifier ES512 = new COSEAlgorithmIdentifier(-36L, "SHA512withECDSA", "SHA-512");
    public static final COSEAlgorithmIdentifier PS256 = new COSEAlgorithmIdentifier(-37L, "SHA256withRSA/PSS", "SHA-256");
    public static final COSEAlgorithmIdentifier PS384 = new COSEAlgorithmIdentifier(-38L, "SHA384withRSA/PSS", "SHA-384");
    public static final COSEAlgorithmIdentifier PS512 = new COSEAlgorithmIdentifier(-39L, "SHA512withRSA/PSS", "SHA-512");
    private static final Map<Long, COSEAlgorithmIdentifier> predefinedAlgorithmMap = new HashMap<Long, COSEAlgorithmIdentifier>();
    private final long value;
    private final String jcaName;
    private final String messageDigestJcaName;

    private COSEAlgorithmIdentifier(long value, String jcaName, String messageDigestJcaName) {
        this.value = value;
        this.jcaName = jcaName;
        this.messageDigestJcaName = messageDigestJcaName;
    }

    public static COSEAlgorithmIdentifier create(long value) {
        COSEAlgorithmIdentifier identifier = predefinedAlgorithmMap.get(value);
        if (identifier == null) {
            identifier = new COSEAlgorithmIdentifier(value, null, null);
        }
        return identifier;
    }

    @JsonCreator
    private static COSEAlgorithmIdentifier deserialize(long value) throws InvalidFormatException {
        return COSEAlgorithmIdentifier.create(value);
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }

    public String getJcaName() {
        return this.jcaName;
    }

    public String getMessageDigestJcaName() {
        return this.messageDigestJcaName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        COSEAlgorithmIdentifier that = (COSEAlgorithmIdentifier)o;
        return this.value == that.value && Objects.equals(this.jcaName, that.jcaName) && Objects.equals(this.messageDigestJcaName, that.messageDigestJcaName);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.jcaName, this.messageDigestJcaName);
    }

    static {
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.RS1.value, RS1);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.RS256.value, RS256);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.RS384.value, RS384);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.RS512.value, RS512);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.ES256.value, ES256);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.ES384.value, ES384);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.ES512.value, ES512);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.PS256.value, PS256);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.PS384.value, PS384);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.PS512.value, PS512);
    }
}

