/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.response.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.response.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.response.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.response.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.util.Arrays;
import java.util.Objects;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="android-key")
public class AndroidKeyAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "android-key";
    @JsonProperty
    private COSEAlgorithmIdentifier alg;
    @JsonProperty
    private byte[] sig;
    @JsonProperty
    private AttestationCertificatePath x5c;

    @JsonCreator
    public AndroidKeyAttestationStatement(@JsonProperty(value="alg") COSEAlgorithmIdentifier alg, @JsonProperty(value="sig") byte[] sig, @JsonProperty(value="x5c") AttestationCertificatePath x5c) {
        this.alg = alg;
        this.sig = sig;
        this.x5c = x5c;
    }

    public COSEAlgorithmIdentifier getAlg() {
        return this.alg;
    }

    public byte[] getSig() {
        return ArrayUtil.clone((byte[])this.sig);
    }

    @Override
    public AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public void validate() {
        if (this.alg == null) {
            throw new ConstraintViolationException("alg must not be null");
        }
        if (this.sig == null) {
            throw new ConstraintViolationException("sig must not be null");
        }
        if (this.x5c == null) {
            throw new ConstraintViolationException("x5c must not be null");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidKeyAttestationStatement that = (AndroidKeyAttestationStatement)o;
        return this.alg == that.alg && Arrays.equals(this.sig, that.sig) && Objects.equals(this.x5c, that.x5c);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.alg, this.x5c});
        result = 31 * result + Arrays.hashCode(this.sig);
        return result;
    }
}

