/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.response;

import com.webauthn4j.response.AbstractWebAuthnContext;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class WebAuthnRegistrationContext
extends AbstractWebAuthnContext {
    private final byte[] attestationObject;

    public WebAuthnRegistrationContext(byte[] clientDataJSON, byte[] attestationObject, String clientExtensionsJSON, ServerProperty serverProperty, boolean userVerificationRequired, boolean userPresenceRequired, List<String> expectedExtensionIds) {
        super(clientDataJSON, clientExtensionsJSON, serverProperty, userVerificationRequired, userPresenceRequired, CollectionUtil.unmodifiableList(expectedExtensionIds));
        this.attestationObject = attestationObject;
    }

    public WebAuthnRegistrationContext(byte[] clientDataJSON, byte[] attestationObject, String clientExtensionsJSON, ServerProperty serverProperty, boolean userVerificationRequired, List<String> expectedExtensionIds) {
        this(clientDataJSON, attestationObject, clientExtensionsJSON, serverProperty, userVerificationRequired, true, expectedExtensionIds);
    }

    public WebAuthnRegistrationContext(byte[] clientDataJSON, byte[] attestationObject, ServerProperty serverProperty, boolean userVerificationRequired) {
        this(clientDataJSON, attestationObject, null, serverProperty, userVerificationRequired, Collections.emptyList());
    }

    public byte[] getAttestationObject() {
        return ArrayUtil.clone((byte[])this.attestationObject);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebAuthnRegistrationContext that = (WebAuthnRegistrationContext)o;
        return Arrays.equals(this.attestationObject, that.attestationObject);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.attestationObject);
        return result;
    }
}

