/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.fasterxml.jackson.core.ObjectCodec;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.jackson.deserializer.AuthenticationExtensionsAuthenticatorOutputsEnvelope;
import com.webauthn4j.converter.jackson.deserializer.CredentialPublicKeyEnvelope;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.response.attestation.authenticator.AAGUID;
import com.webauthn4j.response.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.response.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.response.attestation.authenticator.CredentialPublicKey;
import com.webauthn4j.response.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class AuthenticatorDataConverter {
    private CborConverter cborConverter;

    public AuthenticatorDataConverter(ObjectCodec objectCodec) {
        this.cborConverter = new CborConverter(objectCodec);
    }

    public byte[] convert(AuthenticatorData source) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] rpIdHash = source.getRpIdHash();
            byteArrayOutputStream.write(rpIdHash);
            byteArrayOutputStream.write(new byte[]{source.getFlags()});
            byteArrayOutputStream.write(UnsignedNumberUtil.toBytes((long)source.getSignCount()));
            if (source.getAttestedCredentialData() != null) {
                byteArrayOutputStream.write(this.convert(source.getAttestedCredentialData()));
            }
            byteArrayOutputStream.write(this.convert(source.getExtensions()));
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private byte[] convert(AttestedCredentialData attestationData) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(attestationData.getAaguid().getBytes());
        byteArrayOutputStream.write(UnsignedNumberUtil.toBytes((int)attestationData.getCredentialId().length));
        byteArrayOutputStream.write(attestationData.getCredentialId());
        byteArrayOutputStream.write(this.convert(attestationData.getCredentialPublicKey()));
        return byteArrayOutputStream.toByteArray();
    }

    public AuthenticatorData convert(byte[] value) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(value);
            byte[] rpIdHash = new byte[32];
            byteBuffer.get(rpIdHash, 0, 32);
            byte flags = byteBuffer.get();
            long counter = UnsignedNumberUtil.getUnsignedInt((ByteBuffer)byteBuffer);
            AttestedCredentialData attestationData = AuthenticatorData.checkFlagAT(flags) ? this.convertToAttestedCredentialData(byteBuffer) : null;
            AuthenticationExtensionsAuthenticatorOutputs extensions = AuthenticatorData.checkFlagED(flags) ? this.convertToExtensions(byteBuffer) : new AuthenticationExtensionsAuthenticatorOutputs();
            if (byteBuffer.hasRemaining()) {
                throw new DataConversionException("provided data does not have proper byte layout");
            }
            return new AuthenticatorData(rpIdHash, flags, counter, attestationData, extensions);
        }
        catch (BufferUnderflowException e) {
            throw new DataConversionException("provided data does not have proper byte layout", e);
        }
    }

    private AttestedCredentialData convertToAttestedCredentialData(ByteBuffer byteBuffer) {
        byte[] aaguidBytes = new byte[16];
        byteBuffer.get(aaguidBytes, 0, 16);
        AAGUID aaguid = new AAGUID(aaguidBytes);
        int length = UnsignedNumberUtil.getUnsignedShort((ByteBuffer)byteBuffer);
        byte[] credentialId = new byte[length];
        byteBuffer.get(credentialId, 0, length);
        byte[] remaining = new byte[byteBuffer.remaining()];
        byteBuffer.get(remaining);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(remaining);
        CredentialPublicKeyEnvelope credentialPublicKeyEnvelope = this.convertToCredentialPublicKey(byteArrayInputStream);
        CredentialPublicKey credentialPublicKey = credentialPublicKeyEnvelope.getCredentialPublicKey();
        AttestedCredentialData attestationData = new AttestedCredentialData(aaguid, credentialId, credentialPublicKey);
        int extensionsBufferLength = remaining.length - credentialPublicKeyEnvelope.getLength();
        byteBuffer.position(byteBuffer.position() - extensionsBufferLength);
        return attestationData;
    }

    private CredentialPublicKeyEnvelope convertToCredentialPublicKey(InputStream inputStream) {
        return (CredentialPublicKeyEnvelope)this.cborConverter.readValue(inputStream, CredentialPublicKeyEnvelope.class);
    }

    private AuthenticationExtensionsAuthenticatorOutputs convertToExtensions(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() == 0) {
            return new AuthenticationExtensionsAuthenticatorOutputs();
        }
        byte[] remaining = new byte[byteBuffer.remaining()];
        byteBuffer.get(remaining);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(remaining);
        AuthenticationExtensionsAuthenticatorOutputsEnvelope envelope = (AuthenticationExtensionsAuthenticatorOutputsEnvelope)this.cborConverter.readValue((InputStream)byteArrayInputStream, AuthenticationExtensionsAuthenticatorOutputsEnvelope.class);
        int leftoverLength = remaining.length - envelope.getLength();
        byteBuffer.position(byteBuffer.position() - leftoverLength);
        return envelope.getAuthenticationExtensionsAuthenticatorOutputs();
    }

    byte[] convert(AuthenticationExtensionsAuthenticatorOutputs extensions) {
        if (extensions == null || extensions.isEmpty()) {
            return new byte[0];
        }
        return this.cborConverter.writeValueAsBytes(extensions);
    }

    byte[] convert(CredentialPublicKey credentialPublicKey) {
        return this.cborConverter.writeValueAsBytes(credentialPublicKey);
    }
}

