/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.response.attestation.AttestationObject;
import com.webauthn4j.response.client.CollectedClientData;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.ArrayUtil;
import java.time.Clock;
import java.time.LocalDateTime;

public class RegistrationObject {
    private final CollectedClientData collectedClientData;
    private final byte[] collectedClientDataBytes;
    private final AttestationObject attestationObject;
    private final byte[] attestationObjectBytes;
    private final byte[] authenticatorDataBytes;
    private final ServerProperty serverProperty;
    private final LocalDateTime timestamp;

    public RegistrationObject(CollectedClientData collectedClientData, byte[] collectedClientDataBytes, AttestationObject attestationObject, byte[] attestationObjectBytes, byte[] authenticatorDataBytes, ServerProperty serverProperty) {
        this(collectedClientData, collectedClientDataBytes, attestationObject, attestationObjectBytes, authenticatorDataBytes, serverProperty, LocalDateTime.now(Clock.systemUTC()));
    }

    public RegistrationObject(CollectedClientData collectedClientData, byte[] collectedClientDataBytes, AttestationObject attestationObject, byte[] attestationObjectBytes, byte[] authenticatorDataBytes, ServerProperty serverProperty, LocalDateTime timestamp) {
        this.collectedClientData = collectedClientData;
        this.collectedClientDataBytes = collectedClientDataBytes;
        this.attestationObject = attestationObject;
        this.attestationObjectBytes = attestationObjectBytes;
        this.authenticatorDataBytes = authenticatorDataBytes;
        this.serverProperty = serverProperty;
        this.timestamp = timestamp;
    }

    public CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    public byte[] getCollectedClientDataBytes() {
        return ArrayUtil.clone((byte[])this.collectedClientDataBytes);
    }

    public AttestationObject getAttestationObject() {
        return this.attestationObject;
    }

    public byte[] getAttestationObjectBytes() {
        return ArrayUtil.clone((byte[])this.attestationObjectBytes);
    }

    public byte[] getAuthenticatorDataBytes() {
        return ArrayUtil.clone((byte[])this.authenticatorDataBytes);
    }

    public ServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }
}

