/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util.jws;

import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.registry.Registry;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.util.SignatureUtil;
import com.webauthn4j.util.jws.JWSException;
import com.webauthn4j.util.jws.JWSHeader;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWS<T extends Serializable>
implements Serializable {
    transient Logger logger = LoggerFactory.getLogger(JWS.class);
    private JWSHeader header;
    private T payload;
    private byte[] signature;
    private String headerString;
    private String payloadString;

    public static <T extends Serializable> JWS<T> parse(String value, Registry registry, Class<T> type) {
        JsonConverter jsonConverter = new JsonConverter(registry.getJsonMapper());
        String[] data = value.split("\\.");
        if (data.length != 3) {
            throw new IllegalArgumentException("Invalid JWS");
        }
        String headerString = data[0];
        String payloadString = data[1];
        String signatureString = data[2];
        JWSHeader header = (JWSHeader)jsonConverter.readValue(new String(Base64UrlUtil.decode((String)headerString)), JWSHeader.class);
        Serializable payload = (Serializable)jsonConverter.readValue(new String(Base64UrlUtil.decode((String)payloadString)), type);
        byte[] signature = Base64UrlUtil.decode((String)signatureString);
        return new JWS<Serializable>(header, headerString, payload, payloadString, signature);
    }

    private JWS(JWSHeader header, String headerString, T payload, String payloadString, byte[] signature) {
        this.header = header;
        this.payload = payload;
        this.signature = signature;
        this.headerString = headerString;
        this.payloadString = payloadString;
    }

    public JWSHeader getHeader() {
        return this.header;
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public T getPayload() {
        return this.payload;
    }

    public String getPayloadString() {
        return this.payloadString;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public boolean isValidSignature() {
        String signedData = this.headerString + "." + this.payloadString;
        try {
            Signature signatureObj = SignatureUtil.createSignature((String)this.header.getAlg().getJcaName());
            PublicKey publicKey = this.header.getX5c().getEndEntityAttestationCertificate().getCertificate().getPublicKey();
            signatureObj.initVerify(publicKey);
            signatureObj.update(signedData.getBytes());
            byte[] sig = publicKey instanceof ECPublicKey ? this.convertJWSSignatureToDerSignature(this.signature) : this.signature;
            return signatureObj.verify(sig);
        }
        catch (InvalidKeyException | SignatureException e) {
            this.logger.debug("Signature verification failed", (Throwable)e);
            return false;
        }
    }

    private byte[] convertJWSSignatureToDerSignature(byte[] jwsSignature) {
        int offset;
        byte[] derSignature;
        int len;
        int k;
        int rawLen;
        int i;
        for (i = rawLen = jwsSignature.length / 2; i > 0 && jwsSignature[rawLen - i] == 0; --i) {
        }
        int j = i;
        if (jwsSignature[rawLen - i] < 0) {
            ++j;
        }
        for (k = rawLen; k > 0 && jwsSignature[2 * rawLen - k] == 0; --k) {
        }
        int l = k;
        if (jwsSignature[2 * rawLen - k] < 0) {
            ++l;
        }
        if ((len = 2 + j + 2 + l) > 255) {
            throw new JWSException("Invalid ECDSA signature format");
        }
        if (len < 128) {
            derSignature = new byte[4 + j + 2 + l];
            offset = 1;
        } else {
            derSignature = new byte[5 + j + 2 + l];
            derSignature[1] = -127;
            offset = 2;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)len;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)j;
        System.arraycopy(jwsSignature, rawLen - i, derSignature, offset + j - i, i);
        offset += j;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)l;
        System.arraycopy(jwsSignature, 2 * rawLen - k, derSignature, offset + l - k, k);
        return derSignature;
    }
}

