/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util.jws;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum JWAIdentifier {
    RS1("RS1", "SHA1withRSA"),
    RS256("RS256", "SHA256withRSA"),
    RS384("RS384", "SHA384withRSA"),
    RS512("RS512", "SHA512withRSA"),
    ES256("ES256", "SHA256withECDSA"),
    ES384("ES384", "SHA384withECDSA"),
    ES512("ES512", "SHA512withECDSA");

    private final String name;
    private final String jcaName;

    private JWAIdentifier(String name, String jcaName) {
        this.name = name;
        this.jcaName = jcaName;
    }

    @JsonCreator
    public static JWAIdentifier create(String value) throws InvalidFormatException {
        switch (value) {
            case "ES256": {
                return ES256;
            }
            case "ES384": {
                return ES384;
            }
            case "ES512": {
                return ES512;
            }
            case "RS1": {
                return RS1;
            }
            case "RS256": {
                return RS256;
            }
            case "RS384": {
                return RS384;
            }
            case "RS512": {
                return RS512;
            }
        }
        throw new InvalidFormatException(null, "name is out of range", (Object)value, JWAIdentifier.class);
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String getJcaName() {
        return this.jcaName;
    }
}

