/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.response.attestation.statement;

import com.webauthn4j.response.attestation.statement.TPMUPublicId;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ECCUnique
implements TPMUPublicId {
    private byte[] x;
    private byte[] y;

    public ECCUnique(byte[] x, byte[] y) {
        this.x = x;
        this.y = y;
    }

    public byte[] getX() {
        return ArrayUtil.clone((byte[])this.x);
    }

    public byte[] getY() {
        return ArrayUtil.clone((byte[])this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECCUnique eccUnique = (ECCUnique)o;
        return Arrays.equals(this.x, eccUnique.x) && Arrays.equals(this.y, eccUnique.y);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.x);
        result = 31 * result + Arrays.hashCode(this.y);
        return result;
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(2 + this.x.length + 2 + this.y.length);
        buffer.put(UnsignedNumberUtil.toBytes((int)this.x.length));
        buffer.put(this.x);
        buffer.put(UnsignedNumberUtil.toBytes((int)this.y.length));
        buffer.put(this.y);
        return buffer.array();
    }
}

