/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.trustworthiness.certpath;

import com.webauthn4j.anchor.TrustAnchorProvider;
import com.webauthn4j.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.exception.CertificateException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.util.EnumSet;
import java.util.Set;

public class TrustAnchorCertPathTrustworthinessValidator
implements CertPathTrustworthinessValidator {
    private final TrustAnchorProvider trustAnchorProvider;
    private boolean isRevocationCheckEnabled = false;

    public TrustAnchorCertPathTrustworthinessValidator(TrustAnchorProvider trustAnchorProvider) {
        AssertUtil.notNull((Object)trustAnchorProvider, (String)"trustAnchorProvider must not be null");
        this.trustAnchorProvider = trustAnchorProvider;
    }

    @Override
    public void validate(CertificateBaseAttestationStatement attestationStatement) {
        CertPath certPath = attestationStatement.getX5c().createCertPath();
        Set<TrustAnchor> trustAnchors = this.trustAnchorProvider.provide();
        CertPathValidator certPathValidator = CertificateUtil.createCertPathValidator();
        PKIXParameters certPathParameters = CertificateUtil.createPKIXParameters(trustAnchors);
        if (this.isRevocationCheckEnabled()) {
            PKIXRevocationChecker pkixRevocationChecker = (PKIXRevocationChecker)certPathValidator.getRevocationChecker();
            pkixRevocationChecker.setOptions(EnumSet.of(PKIXRevocationChecker.Option.PREFER_CRLS));
            certPathParameters.addCertPathChecker(pkixRevocationChecker);
        } else {
            certPathParameters.setRevocationEnabled(false);
        }
        try {
            certPathValidator.validate(certPath, certPathParameters);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException("invalid algorithm parameter", e);
        }
        catch (CertPathValidatorException e) {
            throw new CertificateException("invalid cert path", e);
        }
    }

    public boolean isRevocationCheckEnabled() {
        return this.isRevocationCheckEnabled;
    }

    public void setRevocationCheckEnabled(boolean revocationCheckEnabled) {
        this.isRevocationCheckEnabled = revocationCheckEnabled;
    }
}

