/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum COSEAlgorithmIdentifier {
    RS256(-257L, "SHA256withRSA"),
    RS384(-258L, "SHA384withRSA"),
    RS512(-259L, "SHA512withRSA"),
    ES256(-7L, "SHA256withECDSA"),
    ES384(-35L, "SHA384withECDSA"),
    ES512(-36L, "SHA512withECDSA");

    private final long value;
    private final String name;

    private COSEAlgorithmIdentifier(long value, String name) {
        this.value = value;
        this.name = name;
    }

    @JsonCreator
    public static COSEAlgorithmIdentifier create(int value) {
        switch (value) {
            case -257: {
                return RS256;
            }
            case -258: {
                return RS384;
            }
            case -259: {
                return RS512;
            }
            case -7: {
                return ES256;
            }
            case -35: {
                return ES384;
            }
            case -36: {
                return ES512;
            }
        }
        throw new IllegalArgumentException("value is out of range");
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }
}

