/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.attestation.authenticator;

import com.webauthn4j.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.extension.authneticator.AuthenticatorExtensionOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class AuthenticatorData {
    public static final byte BIT_UP = 1;
    public static final byte BIT_UV = 4;
    public static final byte BIT_AT = 64;
    public static final byte BIT_ED = -128;
    private final byte[] rpIdHash;
    private final byte flags;
    private final long signCount;
    private final AttestedCredentialData attestedCredentialData;
    private final Map<String, AuthenticatorExtensionOutput> extensions;

    public AuthenticatorData(byte[] rpIdHash, byte flags, long counter, AttestedCredentialData attestedCredentialData, Map<String, AuthenticatorExtensionOutput> extensions) {
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = counter;
        this.attestedCredentialData = attestedCredentialData;
        this.extensions = extensions;
    }

    public AuthenticatorData(byte[] rpIdHash, byte flags, long counter, AttestedCredentialData attestedCredentialData) {
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = counter;
        this.attestedCredentialData = attestedCredentialData;
        this.extensions = Collections.emptyMap();
    }

    public AuthenticatorData(byte[] rpIdHash, byte flags, long counter, Map<String, AuthenticatorExtensionOutput> extensions) {
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = counter;
        this.attestedCredentialData = null;
        this.extensions = extensions;
    }

    public AuthenticatorData(byte[] rpIdHash, byte flags, long counter) {
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = counter;
        this.attestedCredentialData = null;
        this.extensions = Collections.emptyMap();
    }

    public static boolean checkFlagUP(byte flags) {
        return (flags & 1) != 0;
    }

    public static boolean checkFlagUV(byte flags) {
        return (flags & 4) != 0;
    }

    public static boolean checkFlagAT(byte flags) {
        return (flags & 0x40) != 0;
    }

    public static boolean checkFlagED(byte flags) {
        return (flags & 0xFFFFFF80) != 0;
    }

    public byte[] getRpIdHash() {
        return this.rpIdHash;
    }

    public byte getFlags() {
        return this.flags;
    }

    public boolean isFlagUP() {
        return AuthenticatorData.checkFlagUP(this.flags);
    }

    public boolean isFlagUV() {
        return AuthenticatorData.checkFlagUV(this.flags);
    }

    public boolean isFlagAT() {
        return AuthenticatorData.checkFlagAT(this.flags);
    }

    public boolean isFlagED() {
        return AuthenticatorData.checkFlagED(this.flags);
    }

    public long getSignCount() {
        return this.signCount;
    }

    public AttestedCredentialData getAttestedCredentialData() {
        return this.attestedCredentialData;
    }

    public Map<String, AuthenticatorExtensionOutput> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthenticatorData)) {
            return false;
        }
        AuthenticatorData that = (AuthenticatorData)o;
        if (this.flags != that.flags) {
            return false;
        }
        if (this.signCount != that.signCount) {
            return false;
        }
        if (!Arrays.equals(this.rpIdHash, that.rpIdHash)) {
            return false;
        }
        if (this.attestedCredentialData != null ? !this.attestedCredentialData.equals(that.attestedCredentialData) : that.attestedCredentialData != null) {
            return false;
        }
        return this.extensions != null ? this.extensions.equals(that.extensions) : that.extensions == null;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.rpIdHash);
        result = 31 * result + this.flags;
        result = 31 * result + (int)(this.signCount ^ this.signCount >>> 32);
        result = 31 * result + (this.attestedCredentialData != null ? this.attestedCredentialData.hashCode() : 0);
        result = 31 * result + (this.extensions != null ? this.extensions.hashCode() : 0);
        return result;
    }
}

