/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j;

import com.webauthn4j.server.ServerProperty;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

abstract class AbstractWebAuthnContext {
    private final byte[] clientDataJSON;
    private final String clientExtensionsJSON;
    private final ServerProperty serverProperty;
    private boolean userVerificationRequired;
    private List<String> expectedExtensionIds;

    public AbstractWebAuthnContext(byte[] clientDataJSON, String clientExtensionsJSON, ServerProperty serverProperty, boolean userVerificationRequired, List<String> expectedExtensionIds) {
        this.clientDataJSON = clientDataJSON;
        this.clientExtensionsJSON = clientExtensionsJSON;
        this.serverProperty = serverProperty;
        this.userVerificationRequired = userVerificationRequired;
        this.expectedExtensionIds = expectedExtensionIds;
    }

    public byte[] getClientDataJSON() {
        return this.clientDataJSON;
    }

    public String getClientExtensionsJSON() {
        return this.clientExtensionsJSON;
    }

    public ServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public boolean isUserVerificationRequired() {
        return this.userVerificationRequired;
    }

    public List<String> getExpectedExtensionIds() {
        return this.expectedExtensionIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractWebAuthnContext that = (AbstractWebAuthnContext)o;
        return this.userVerificationRequired == that.userVerificationRequired && Arrays.equals(this.clientDataJSON, that.clientDataJSON) && Objects.equals(this.clientExtensionsJSON, that.clientExtensionsJSON) && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.expectedExtensionIds, that.expectedExtensionIds);
    }

    public int hashCode() {
        int result = Objects.hash(this.clientExtensionsJSON, this.serverProperty, this.userVerificationRequired, this.expectedExtensionIds);
        result = 31 * result + Arrays.hashCode(this.clientDataJSON);
        return result;
    }
}

