/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.attestation.statement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.WIP;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.util.Arrays;
import java.util.Objects;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="packed")
@WIP
public class PackedAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "packed";
    @JsonProperty
    private COSEAlgorithmIdentifier alg;
    @JsonProperty
    private byte[] sig;
    @JsonProperty
    private AttestationCertificatePath x5c;
    @JsonProperty
    private byte[] ecdaaKeyId;

    public PackedAttestationStatement(COSEAlgorithmIdentifier alg, byte[] sig, AttestationCertificatePath x5c, byte[] ecdaaKeyId) {
        this.alg = alg;
        this.sig = sig;
        this.x5c = x5c;
        this.ecdaaKeyId = ecdaaKeyId;
    }

    public PackedAttestationStatement() {
    }

    public COSEAlgorithmIdentifier getAlg() {
        return this.alg;
    }

    public byte[] getSig() {
        return this.sig;
    }

    @Override
    public AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    public byte[] getEcdaaKeyId() {
        return this.ecdaaKeyId;
    }

    @Override
    @JsonIgnore
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public void validate() {
        if (this.x5c == null && this.ecdaaKeyId == null) {
            throw new ConstraintViolationException("x5c or ecdaaKeyId must not be null");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackedAttestationStatement that = (PackedAttestationStatement)o;
        return this.alg == that.alg && Arrays.equals(this.sig, that.sig) && Objects.equals(this.x5c, that.x5c) && Arrays.equals(this.ecdaaKeyId, that.ecdaaKeyId);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.alg, this.x5c});
        result = 31 * result + Arrays.hashCode(this.sig);
        result = 31 * result + Arrays.hashCode(this.ecdaaKeyId);
        return result;
    }
}

