/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.attestation.statement;

import com.webauthn4j.validator.exception.CertificateException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import sun.security.x509.X500Name;

public class AttestationCertificate {
    public static final int CERTIFICATE_VERSION_3 = 3;
    public static final int NON_CA = -1;
    private static final Map<String, String> cHashMap = new HashMap<String, String>();
    private X509Certificate certificate;

    public AttestationCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getSubjectCountry() {
        try {
            return this.getX500Name().getCountry();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getSubjectOrganization() {
        try {
            return this.getX500Name().getOrganization();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getSubjectOrganizationUnit() {
        try {
            return this.getX500Name().getOrganizationalUnit();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getSubjectCommonName() {
        try {
            return this.getX500Name().getCommonName();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void validate() {
        if (this.certificate.getVersion() != 3) {
            throw new CertificateException("Attestation certificate must be version 3");
        }
        String country = this.getSubjectCountry();
        if (country == null || country.isEmpty()) {
            throw new CertificateException("Subject-C must be present");
        }
        String organization = this.getSubjectOrganization();
        if (organization == null || organization.isEmpty()) {
            throw new CertificateException("Subject-O must be present");
        }
        String organizationUnit = this.getSubjectOrganizationUnit();
        if (organizationUnit == null || !organizationUnit.equals("Authenticator Attestation")) {
            throw new CertificateException("Subject-OU must be present");
        }
        String commonName = this.getSubjectCommonName();
        if (commonName == null || commonName.isEmpty()) {
            throw new CertificateException("Subject-CN must be present");
        }
        if (this.certificate.getBasicConstraints() != -1) {
            throw new CertificateException("Attestation certificate must not be CA certificate");
        }
    }

    private X500Name getX500Name() throws IOException {
        return new X500Name(this.certificate.getSubjectX500Principal().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestationCertificate that = (AttestationCertificate)o;
        return Objects.equals(this.certificate, that.certificate);
    }

    public int hashCode() {
        return Objects.hash(this.certificate);
    }

    static {
        cHashMap.put("", "");
    }
}

