/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.attestation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.webauthn4j.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.attestation.statement.AttestationStatement;
import java.util.Objects;

public class AttestationObject {
    @JsonProperty(value="authData")
    private AuthenticatorData authenticatorData;
    @JsonProperty(value="attStmt")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="fmt")
    private AttestationStatement attestationStatement;

    public AttestationObject(AuthenticatorData authenticatorData, AttestationStatement attestationStatement) {
        this.authenticatorData = authenticatorData;
        this.attestationStatement = attestationStatement;
    }

    public AttestationObject() {
    }

    public AuthenticatorData getAuthenticatorData() {
        return this.authenticatorData;
    }

    @JsonProperty(value="fmt")
    public String getFormat() {
        return this.attestationStatement.getFormat();
    }

    public AttestationStatement getAttestationStatement() {
        return this.attestationStatement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestationObject that = (AttestationObject)o;
        return Objects.equals(this.authenticatorData, that.authenticatorData) && Objects.equals(this.attestationStatement, that.attestationStatement);
    }

    public int hashCode() {
        return Objects.hash(this.authenticatorData, this.attestationStatement);
    }
}

