/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.WebAuthnManager;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.WebAuthnRegistrationContext;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.exception.WebAuthnException;
import com.webauthn4j.validator.CustomRegistrationValidator;
import com.webauthn4j.validator.WebAuthnRegistrationContextValidationResponse;
import com.webauthn4j.validator.attestation.statement.AttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidkey.NullAndroidKeyAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidsafetynet.NullAndroidSafetyNetAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.none.NoneAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.packed.NullPackedAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.tpm.NullTPMAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.u2f.NullFIDOU2FAttestationStatementValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.NullCertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.ecdaa.ECDAATrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.ecdaa.NullECDAATrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.DefaultSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.NullSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Deprecated
public class WebAuthnRegistrationContextValidator {
    private final List<CustomRegistrationValidator> customRegistrationValidators = new ArrayList<CustomRegistrationValidator>();
    private final WebAuthnManager webAuthnManager;

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, new DefaultSelfAttestationTrustworthinessValidator(), new JsonConverter(), new CborConverter());
    }

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator, SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, selfAttestationTrustworthinessValidator, new JsonConverter(), new CborConverter());
    }

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator, JsonConverter jsonConverter, CborConverter cborConverter) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, new DefaultSelfAttestationTrustworthinessValidator(), jsonConverter, cborConverter);
    }

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator, SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator, JsonConverter jsonConverter, CborConverter cborConverter) {
        AssertUtil.notNull(attestationStatementValidators, (String)"attestationStatementValidators must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessValidator, (String)"certPathTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)ecdaaTrustworthinessValidator, (String)"ecdaaTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessValidator, (String)"selfAttestationTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)jsonConverter, (String)"jsonConverter must not be null");
        AssertUtil.notNull((Object)cborConverter, (String)"cborConverter must not be null");
        this.webAuthnManager = new WebAuthnManager(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, selfAttestationTrustworthinessValidator, this.customRegistrationValidators, Collections.emptyList(), new ObjectConverter(jsonConverter, cborConverter));
    }

    public static WebAuthnRegistrationContextValidator createNonStrictRegistrationContextValidator() {
        return WebAuthnRegistrationContextValidator.createNonStrictRegistrationContextValidator(new JsonConverter(), new CborConverter());
    }

    public static WebAuthnRegistrationContextValidator createNonStrictRegistrationContextValidator(JsonConverter jsonConverter, CborConverter cborConverter) {
        return new WebAuthnRegistrationContextValidator(Arrays.asList(new NoneAttestationStatementValidator(), new NullFIDOU2FAttestationStatementValidator(), new NullPackedAttestationStatementValidator(), new NullTPMAttestationStatementValidator(), new NullAndroidKeyAttestationStatementValidator(), new NullAndroidSafetyNetAttestationStatementValidator()), new NullCertPathTrustworthinessValidator(), new NullECDAATrustworthinessValidator(), new NullSelfAttestationTrustworthinessValidator(), jsonConverter, cborConverter);
    }

    public WebAuthnRegistrationContextValidationResponse validate(WebAuthnRegistrationContext webAuthnRegistrationContext) throws WebAuthnException {
        RegistrationRequest registrationRequest = new RegistrationRequest(webAuthnRegistrationContext.getAttestationObject(), webAuthnRegistrationContext.getClientDataJSON(), webAuthnRegistrationContext.getClientExtensionsJSON(), webAuthnRegistrationContext.getTransports());
        RegistrationParameters registrationParameters = new RegistrationParameters(webAuthnRegistrationContext.getServerProperty(), webAuthnRegistrationContext.isUserVerificationRequired(), webAuthnRegistrationContext.isUserPresenceRequired(), webAuthnRegistrationContext.getExpectedExtensionIds());
        RegistrationData registrationData = this.webAuthnManager.validate(registrationRequest, registrationParameters);
        return new WebAuthnRegistrationContextValidationResponse(registrationData.getCollectedClientData(), registrationData.getAttestationObject(), registrationData.getClientExtensions());
    }

    public List<CustomRegistrationValidator> getCustomRegistrationValidators() {
        return this.customRegistrationValidators;
    }
}

