/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.CoreRegistrationData;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.MessageDigestUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class RegistrationData
extends CoreRegistrationData {
    private final CollectedClientData collectedClientData;
    private final byte[] collectedClientDataBytes;
    private final AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions;
    private final Set<AuthenticatorTransport> transports;

    public RegistrationData(@Nullable AttestationObject attestationObject, @Nullable byte[] attestationObjectBytes, @Nullable CollectedClientData collectedClientData, @Nullable byte[] collectedClientDataBytes, @Nullable AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, @Nullable Set<AuthenticatorTransport> transports) {
        super(attestationObject, attestationObjectBytes, collectedClientDataBytes == null ? null : MessageDigestUtil.createSHA256().digest(collectedClientDataBytes));
        this.collectedClientData = collectedClientData;
        this.collectedClientDataBytes = ArrayUtil.clone((byte[])collectedClientDataBytes);
        this.clientExtensions = clientExtensions;
        this.transports = transports;
    }

    @Nullable
    public CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    @Nullable
    public byte[] getCollectedClientDataBytes() {
        return ArrayUtil.clone((byte[])this.collectedClientDataBytes);
    }

    @Nullable
    public AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> getClientExtensions() {
        return this.clientExtensions;
    }

    @Nullable
    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistrationData that = (RegistrationData)o;
        return Objects.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.collectedClientDataBytes, that.collectedClientDataBytes) && Objects.equals(this.clientExtensions, that.clientExtensions) && Objects.equals(this.transports, that.transports);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.collectedClientData, this.clientExtensions, this.transports);
        result = 31 * result + Arrays.hashCode(this.collectedClientDataBytes);
        return result;
    }

    @Override
    public String toString() {
        return "RegistrationData(collectedClientData=" + String.valueOf(this.collectedClientData) + ", clientExtensions=" + String.valueOf(this.clientExtensions) + ", transports=" + String.valueOf(this.transports) + ")";
    }
}

