/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.AuthenticatorAttachment;
import com.webauthn4j.data.AuthenticatorResponse;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.Base64UrlUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicKeyCredential<R extends AuthenticatorResponse, E extends ExtensionClientOutput> {
    private final String id;
    private final byte[] rawId;
    private final R response;
    private final AuthenticatorAttachment authenticatorAttachment;
    private final AuthenticationExtensionsClientOutputs<E> clientExtensionResults;

    public PublicKeyCredential(@Nullable byte[] credentialId, @Nullable R response, @Nullable AuthenticationExtensionsClientOutputs<E> clientExtensionResults) {
        this(credentialId, response, null, clientExtensionResults);
    }

    @JsonCreator
    public PublicKeyCredential(@JsonProperty(value="credentialId") @Nullable byte[] credentialId, @JsonProperty(value="response") @Nullable R response, @JsonProperty(value="authenticatorAttachment") @Nullable AuthenticatorAttachment authenticatorAttachment, @JsonProperty(value="clientExtensionResults") @Nullable AuthenticationExtensionsClientOutputs<E> clientExtensionResults) {
        this.id = credentialId == null ? null : Base64UrlUtil.encodeToString((byte[])credentialId);
        this.rawId = credentialId;
        this.response = response;
        this.authenticatorAttachment = authenticatorAttachment;
        this.clientExtensionResults = clientExtensionResults;
    }

    @NotNull
    public String getType() {
        return PublicKeyCredentialType.PUBLIC_KEY.getValue();
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public byte[] getRawId() {
        return ArrayUtil.clone((byte[])this.rawId);
    }

    @Nullable
    public R getResponse() {
        return this.response;
    }

    @Nullable
    public AuthenticatorAttachment getAuthenticatorAttachment() {
        return this.authenticatorAttachment;
    }

    @JsonIgnore
    @Deprecated
    @Nullable
    public R getAuthenticatorResponse() {
        return this.response;
    }

    @Nullable
    public AuthenticationExtensionsClientOutputs<E> getClientExtensionResults() {
        return this.clientExtensionResults;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredential that = (PublicKeyCredential)o;
        return Objects.equals(this.id, that.id) && Arrays.equals(this.rawId, that.rawId) && Objects.equals(this.response, that.response) && Objects.equals(this.authenticatorAttachment, that.authenticatorAttachment) && Objects.equals(this.clientExtensionResults, that.clientExtensionResults);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.response, this.authenticatorAttachment, this.clientExtensionResults);
        result = 31 * result + Arrays.hashCode(this.rawId);
        return result;
    }

    public String toString() {
        return "PublicKeyCredential(id=" + this.id + ", response=" + String.valueOf(this.response) + ", authenticatorAttachment=" + String.valueOf(this.authenticatorAttachment) + ", clientExtensionResults=" + String.valueOf(this.clientExtensionResults) + ")";
    }
}

