/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.attestation.statement.androidkey;

import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.exception.BadAttestationStatementException;
import com.webauthn4j.verifier.exception.KeyDescriptionValidationException;
import com.webauthn4j.verifier.internal.asn1.ASN1;
import com.webauthn4j.verifier.internal.asn1.ASN1Primitive;
import com.webauthn4j.verifier.internal.asn1.ASN1Structure;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDescriptionVerifier {
    public static final String ATTESTATION_EXTENSION_OID = "1.3.6.1.4.1.11129.2.1.17";
    public static final int ATTESTATION_CHALLENGE_INDEX = 4;
    public static final int SW_ENFORCED_INDEX = 6;
    public static final int TEE_ENFORCED_INDEX = 7;
    public static final int KM_TAG_PURPOSE = 1;
    public static final int KM_TAG_ALL_APPLICATIONS = 600;
    public static final int KM_TAG_CREATION_DATE_TIME = 701;
    public static final int KM_TAG_ORIGIN = 702;
    public static final int KM_ORIGIN_GENERATED = 0;
    public static final int KM_PURPOSE_SIGN = 2;
    private final Logger logger = LoggerFactory.getLogger(KeyDescriptionVerifier.class);

    public void verify(@NotNull X509Certificate x509Certificate, @NotNull byte[] clientDataHash, boolean teeEnforcedOnly) {
        AssertUtil.notNull((Object)x509Certificate, (String)"x509Certificate must not be null");
        AssertUtil.notNull((Object)clientDataHash, (String)"clientDataHash must not be null");
        ASN1Structure keyDescription = this.extractKeyDescription(x509Certificate);
        this.doVerify(keyDescription, clientDataHash, teeEnforcedOnly);
    }

    @NotNull
    ASN1Structure extractKeyDescription(@NotNull X509Certificate x509Certificate) {
        byte[] attestationExtensionBytes = x509Certificate.getExtensionValue(ATTESTATION_EXTENSION_OID);
        if (attestationExtensionBytes == null) {
            throw new KeyDescriptionValidationException("KeyDescription must not be null");
        }
        return ASN1Primitive.parse(attestationExtensionBytes).getValueAsASN1Structure();
    }

    void doVerify(@NotNull ASN1Structure keyDescription, @NotNull byte[] clientDataHash, boolean teeEnforcedOnly) {
        byte[] attestationChallenge = ((ASN1Primitive)keyDescription.get(4)).getValue();
        if (!Arrays.equals(attestationChallenge, clientDataHash)) {
            throw new KeyDescriptionValidationException("Attestation challenge doesn't match.");
        }
        ASN1Structure softwareEnforced = (ASN1Structure)keyDescription.get(6);
        ASN1Structure teeEnforced = (ASN1Structure)keyDescription.get(7);
        if (this.findAuthorizationListEntry(softwareEnforced, 600) != null || this.findAuthorizationListEntry(teeEnforced, 600) != null) {
            throw new KeyDescriptionValidationException("Key is not scoped properly.");
        }
        this.verifyAuthorizationList(teeEnforcedOnly, softwareEnforced, teeEnforced);
    }

    private void verifyAuthorizationList(boolean teeEnforcedOnly, @NotNull ASN1Structure softwareEnforced, @NotNull ASN1Structure teeEnforced) {
        if (teeEnforcedOnly) {
            if (!this.isKeyGeneratedInKeymaster(this.findAuthorizationListEntry(teeEnforced, 702))) {
                throw new KeyDescriptionValidationException("Key is not generated in keymaster.");
            }
            if (!this.containsValidPurpose(this.findAuthorizationListEntry(teeEnforced, 1))) {
                throw new KeyDescriptionValidationException("Key purpose is invalid.");
            }
        } else {
            if (!this.isKeyGeneratedInKeymaster(this.findAuthorizationListEntry(teeEnforced, 702)) && !this.isKeyGeneratedInKeymaster(this.findAuthorizationListEntry(softwareEnforced, 702))) {
                throw new KeyDescriptionValidationException("Key is not generated in keymaster.");
            }
            if (!this.containsValidPurpose(this.findAuthorizationListEntry(teeEnforced, 1)) && !this.containsValidPurpose(this.findAuthorizationListEntry(softwareEnforced, 1))) {
                throw new KeyDescriptionValidationException("Key purpose is invalid.");
            }
        }
    }

    private boolean isKeyGeneratedInKeymaster(@Nullable ASN1 origin) {
        try {
            return Objects.equals(this.getIntegerFromAsn1(origin), BigInteger.valueOf(0L));
        }
        catch (RuntimeException e) {
            this.logger.debug("Failed to retrieve origin.", (Throwable)e);
            return false;
        }
    }

    private boolean containsValidPurpose(@Nullable ASN1 purposes) {
        try {
            if (purposes == null) {
                return false;
            }
            ASN1Structure set = (ASN1Structure)purposes;
            for (ASN1 valueItem : set) {
                ASN1Primitive purpose = (ASN1Primitive)valueItem;
                if (!Objects.equals(this.getIntegerFromAsn1(purpose), BigInteger.valueOf(2L))) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            this.logger.debug("Failed to retrieve purpose.", (Throwable)e);
            return false;
        }
    }

    @Nullable
    private BigInteger getIntegerFromAsn1(ASN1 asn1Value) {
        if (asn1Value == null) {
            return null;
        }
        if (asn1Value.getClass() != ASN1Primitive.class || asn1Value.getTag().getNumber() != 2) {
            throw new BadAttestationStatementException(String.format("ASN1Integer is expected. Found %s instead.", asn1Value.getClass().getName()));
        }
        return ((ASN1Primitive)asn1Value).getValueAsBigInteger();
    }

    @Nullable
    private ASN1 findAuthorizationListEntry(@NotNull ASN1Structure authorizationList, int tag) {
        for (ASN1 listItem : authorizationList) {
            ASN1Structure entry = (ASN1Structure)listItem;
            if (entry.getTag().getNumber() != tag) continue;
            return entry.get(0);
        }
        return null;
    }
}

