/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.authenticator;

import com.webauthn4j.data.extension.SingleValueExtensionInputBase;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.HMACGetSecretAuthenticatorInput;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import org.jetbrains.annotations.NotNull;

public class HMACSecretAuthenticationExtensionAuthenticatorInput
extends SingleValueExtensionInputBase<HMACGetSecretAuthenticatorInput>
implements AuthenticationExtensionAuthenticatorInput {
    public static final String ID = "hmac-secret";
    public static final String KEY_HMAC_SECRET = "hmac-secret";

    public HMACSecretAuthenticationExtensionAuthenticatorInput(@NotNull HMACGetSecretAuthenticatorInput value) {
        super(value);
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "hmac-secret";
    }

    @Override
    public void validate() {
        if (this.getValue() == null) {
            throw new ConstraintViolationException("value must not be null");
        }
        if (((HMACGetSecretAuthenticatorInput)this.getValue()).getKeyAgreement() == null) {
            throw new ConstraintViolationException("keyAgreement must not be null");
        }
        if (((HMACGetSecretAuthenticatorInput)this.getValue()).getSaltAuth() == null) {
            throw new ConstraintViolationException("saltAuth must not be null");
        }
        if (((HMACGetSecretAuthenticatorInput)this.getValue()).getSaltEnc() == null) {
            throw new ConstraintViolationException("saltEnc must not be null");
        }
        if (((HMACGetSecretAuthenticatorInput)this.getValue()).getSaltAuth().length != 32) {
            throw new ConstraintViolationException("saltAuth must be 32 bytes length");
        }
        if (((HMACGetSecretAuthenticatorInput)this.getValue()).getSaltEnc().length != 32) {
            throw new ConstraintViolationException("saltEnc must be 32 bytes length");
        }
    }
}

