/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.authenticator.CoreAuthenticator;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreAuthenticationObject {
    private final byte[] credentialId;
    private final AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData;
    private final byte[] authenticatorDataBytes;
    private final byte[] clientDataHash;
    private final CoreServerProperty serverProperty;
    private final CoreAuthenticator authenticator;

    public CoreAuthenticationObject(@NotNull byte[] credentialId, @NotNull AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData, @NotNull byte[] authenticatorDataBytes, @NotNull byte[] clientDataHash, @NotNull CoreServerProperty serverProperty, @NotNull CoreAuthenticator authenticator) {
        AssertUtil.notNull((Object)credentialId, (String)"credentialId must not be null");
        AssertUtil.notNull(authenticatorData, (String)"authenticatorData must not be null");
        AssertUtil.notNull((Object)authenticatorDataBytes, (String)"authenticatorDataBytes must not be null");
        AssertUtil.notNull((Object)clientDataHash, (String)"clientDataHash must not be null");
        AssertUtil.notNull((Object)serverProperty, (String)"serverProperty must not be null");
        AssertUtil.notNull((Object)authenticator, (String)"authenticator must not be null");
        this.credentialId = ArrayUtil.clone((byte[])credentialId);
        this.authenticatorData = authenticatorData;
        this.authenticatorDataBytes = ArrayUtil.clone((byte[])authenticatorDataBytes);
        this.clientDataHash = ArrayUtil.clone((byte[])clientDataHash);
        this.serverProperty = serverProperty;
        this.authenticator = authenticator;
    }

    @NotNull
    public byte[] getCredentialId() {
        return ArrayUtil.clone((byte[])this.credentialId);
    }

    @NotNull
    public AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> getAuthenticatorData() {
        return this.authenticatorData;
    }

    @NotNull
    public byte[] getAuthenticatorDataBytes() {
        return ArrayUtil.clone((byte[])this.authenticatorDataBytes);
    }

    @NotNull
    public byte[] getClientDataHash() {
        return ArrayUtil.clone((byte[])this.clientDataHash);
    }

    @NotNull
    public CoreServerProperty getServerProperty() {
        return this.serverProperty;
    }

    @NotNull
    public CoreAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreAuthenticationObject that = (CoreAuthenticationObject)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Objects.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.authenticatorDataBytes, that.authenticatorDataBytes) && Arrays.equals(this.clientDataHash, that.clientDataHash) && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.authenticator, that.authenticator);
    }

    public int hashCode() {
        int result = Objects.hash(this.authenticatorData, this.serverProperty, this.authenticator);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        result = 31 * result + Arrays.hashCode(this.authenticatorDataBytes);
        result = 31 * result + Arrays.hashCode(this.clientDataHash);
        return result;
    }
}

