/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.credential.CoreCredentialRecord;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.AssertionSignatureValidator;
import com.webauthn4j.validator.AuthenticationObject;
import com.webauthn4j.validator.AuthenticatorExtensionValidator;
import com.webauthn4j.validator.BeanAssertUtil;
import com.webauthn4j.validator.ChallengeValidator;
import com.webauthn4j.validator.ClientExtensionValidator;
import com.webauthn4j.validator.CoreMaliciousCounterValueHandler;
import com.webauthn4j.validator.CustomAuthenticationValidator;
import com.webauthn4j.validator.DefaultCoreMaliciousCounterValueHandler;
import com.webauthn4j.validator.OriginValidator;
import com.webauthn4j.validator.OriginValidatorImpl;
import com.webauthn4j.validator.RpIdHashValidator;
import com.webauthn4j.validator.TokenBindingValidator;
import com.webauthn4j.validator.exception.BadBackupEligibleFlagException;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import com.webauthn4j.validator.exception.CrossOriginException;
import com.webauthn4j.validator.exception.IllegalBackupStateException;
import com.webauthn4j.validator.exception.InconsistentClientDataTypeException;
import com.webauthn4j.validator.exception.NotAllowedCredentialIdException;
import com.webauthn4j.validator.exception.UserNotPresentException;
import com.webauthn4j.validator.exception.UserNotVerifiedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticationDataValidator {
    private final ChallengeValidator challengeValidator = new ChallengeValidator();
    private final TokenBindingValidator tokenBindingValidator = new TokenBindingValidator();
    private final RpIdHashValidator rpIdHashValidator = new RpIdHashValidator();
    private final AssertionSignatureValidator assertionSignatureValidator = new AssertionSignatureValidator();
    private final ClientExtensionValidator clientExtensionValidator = new ClientExtensionValidator();
    private final AuthenticatorExtensionValidator authenticatorExtensionValidator = new AuthenticatorExtensionValidator();
    private final List<CustomAuthenticationValidator> customAuthenticationValidators;
    private OriginValidator originValidator = new OriginValidatorImpl();
    private CoreMaliciousCounterValueHandler maliciousCounterValueHandler = new DefaultCoreMaliciousCounterValueHandler();
    private boolean crossOriginAllowed = false;

    public AuthenticationDataValidator(@NotNull List<CustomAuthenticationValidator> customAuthenticationValidators) {
        AssertUtil.notNull(customAuthenticationValidators, (String)"customAuthenticationValidators must not be null");
        this.customAuthenticationValidators = customAuthenticationValidators;
    }

    public AuthenticationDataValidator() {
        this.customAuthenticationValidators = new ArrayList<CustomAuthenticationValidator>();
    }

    public void validate(@NotNull AuthenticationData authenticationData, @NotNull AuthenticationParameters authenticationParameters) {
        BeanAssertUtil.validate(authenticationData);
        AssertUtil.notNull((Object)authenticationParameters, (String)"authenticationParameters must not be null");
        AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions = authenticationData.getClientExtensions();
        byte[] credentialId = authenticationData.getCredentialId();
        List<byte[]> allowCredentials = authenticationParameters.getAllowCredentials();
        this.validateCredentialId(credentialId, allowCredentials);
        byte[] cData = authenticationData.getCollectedClientDataBytes();
        byte[] aData = authenticationData.getAuthenticatorDataBytes();
        CollectedClientData collectedClientData = authenticationData.getCollectedClientData();
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticationData.getAuthenticatorData();
        ServerProperty serverProperty = authenticationParameters.getServerProperty();
        BeanAssertUtil.validate(collectedClientData);
        BeanAssertUtil.validate(authenticatorData);
        this.validateAuthenticatorData(authenticatorData);
        Authenticator authenticator = authenticationParameters.getAuthenticator();
        AuthenticationObject authenticationObject = new AuthenticationObject(credentialId, authenticatorData, aData, collectedClientData, cData, clientExtensions, serverProperty, authenticator);
        if (!Objects.equals(collectedClientData.getType(), ClientDataType.WEBAUTHN_GET)) {
            throw new InconsistentClientDataTypeException("ClientData.type must be 'get' on authentication, but it isn't.");
        }
        this.challengeValidator.validate(collectedClientData, serverProperty);
        this.originValidator.validate(authenticationObject);
        this.validateClientDataCrossOrigin(collectedClientData);
        this.tokenBindingValidator.validate(collectedClientData.getTokenBinding(), serverProperty.getTokenBindingId());
        this.rpIdHashValidator.validate(authenticatorData.getRpIdHash(), serverProperty);
        if (authenticationParameters.isUserPresenceRequired() && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Validator is configured to check user present, but UP flag in authenticatorData is not set.");
        }
        if (authenticationParameters.isUserVerificationRequired() && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Validator is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
        this.validateBEBSFlags(authenticatorData);
        AuthenticationDataValidator.validateBEFlag(authenticator, authenticatorData);
        AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        this.clientExtensionValidator.validate(clientExtensions);
        this.authenticatorExtensionValidator.validate(authenticationExtensionsAuthenticatorOutputs);
        this.assertionSignatureValidator.validate(authenticationData, authenticator.getAttestedCredentialData().getCOSEKey());
        long presentedSignCount = authenticatorData.getSignCount();
        long storedSignCount = authenticator.getCounter();
        if ((presentedSignCount > 0L || storedSignCount > 0L) && presentedSignCount <= storedSignCount) {
            this.maliciousCounterValueHandler.maliciousCounterValueDetected(authenticationObject);
        }
        AuthenticationDataValidator.updateRecord(authenticator, authenticatorData);
        for (CustomAuthenticationValidator customAuthenticationValidator : this.customAuthenticationValidators) {
            customAuthenticationValidator.validate(authenticationObject);
        }
    }

    static void validateBEFlag(Authenticator authenticator, AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        CoreCredentialRecord coreCredentialRecord;
        Boolean backEligibleRecordValue;
        if (authenticator instanceof CoreCredentialRecord && (backEligibleRecordValue = (coreCredentialRecord = (CoreCredentialRecord)((Object)authenticator)).isBackupEligible()) != null) {
            if (backEligibleRecordValue.booleanValue()) {
                if (!authenticatorData.isFlagBE()) {
                    throw new BadBackupEligibleFlagException("Although credential record BE flag is set, current BE flag is not set");
                }
            } else if (authenticatorData.isFlagBE()) {
                throw new BadBackupEligibleFlagException("Although credential record BE flag is not set, current BE flag is set");
            }
        }
    }

    static void updateRecord(Authenticator authenticator, AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        authenticator.setCounter(authenticatorData.getSignCount());
        if (authenticator instanceof CoreCredentialRecord) {
            CoreCredentialRecord coreCredentialRecord = (CoreCredentialRecord)((Object)authenticator);
            coreCredentialRecord.setBackedUp(authenticatorData.isFlagBS());
            Boolean uvInitializedRecord = coreCredentialRecord.isUvInitialized();
            if (Objects.isNull(uvInitializedRecord) || Boolean.FALSE.equals(uvInitializedRecord)) {
                coreCredentialRecord.setUvInitialized(authenticatorData.isFlagUV());
            }
        }
    }

    void validateCredentialId(byte[] credentialId, @Nullable List<byte[]> allowCredentials) {
        if (allowCredentials != null && allowCredentials.stream().noneMatch(item -> Arrays.equals(item, credentialId))) {
            throw new NotAllowedCredentialIdException("credentialId not listed in allowCredentials is used.");
        }
    }

    void validateClientDataCrossOrigin(CollectedClientData collectedClientData) {
        if (!this.crossOriginAllowed && Objects.equals(true, collectedClientData.getCrossOrigin())) {
            throw new CrossOriginException("Cross-origin request is prohibited. Relax AuthenticationDataValidator config if necessary.");
        }
    }

    void validateAuthenticatorData(@NotNull AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() != null) {
            throw new ConstraintViolationException("attestedCredentialData must be null on authentication");
        }
    }

    void validateBEBSFlags(AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        if (!authenticatorData.isFlagBE() && authenticatorData.isFlagBS()) {
            throw new IllegalBackupStateException("Backup state bit must not be set if backup eligibility bit is not set");
        }
    }

    @NotNull
    public CoreMaliciousCounterValueHandler getMaliciousCounterValueHandler() {
        return this.maliciousCounterValueHandler;
    }

    public void setMaliciousCounterValueHandler(@NotNull CoreMaliciousCounterValueHandler maliciousCounterValueHandler) {
        AssertUtil.notNull((Object)maliciousCounterValueHandler, (String)"maliciousCounterValueHandler must not be null");
        this.maliciousCounterValueHandler = maliciousCounterValueHandler;
    }

    public OriginValidator getOriginValidator() {
        return this.originValidator;
    }

    public void setOriginValidator(OriginValidator originValidator) {
        this.originValidator = originValidator;
    }

    @NotNull
    public List<CustomAuthenticationValidator> getCustomAuthenticationValidators() {
        return this.customAuthenticationValidators;
    }

    public boolean isCrossOriginAllowed() {
        return this.crossOriginAllowed;
    }

    public void setCrossOriginAllowed(boolean crossOriginAllowed) {
        this.crossOriginAllowed = crossOriginAllowed;
    }
}

