/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.client;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.extension.HMACGetSecretOutput;
import com.webauthn4j.data.extension.SingleValueExtensionOutputBase;
import com.webauthn4j.data.extension.UvmEntries;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.CredentialPropertiesExtensionClientOutput;
import com.webauthn4j.data.extension.client.CredentialPropertiesOutput;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.data.extension.client.FIDOAppIDExtensionClientOutput;
import com.webauthn4j.data.extension.client.HMACSecretAuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.HMACSecretRegistrationExtensionClientOutput;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.data.extension.client.UserVerificationMethodExtensionClientOutput;
import com.webauthn4j.util.AssertUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticationExtensionsClientOutputs<T extends ExtensionClientOutput> {
    @JsonIgnore
    private final Map<String, Object> unknowns = new HashMap<String, Object>();
    @JsonProperty
    private Boolean appid;
    @JsonProperty
    private UvmEntries uvm;
    @JsonProperty
    private CredentialPropertiesOutput credProps;
    @JsonProperty
    private Boolean hmacCreateSecret;
    @JsonProperty
    private HMACGetSecretOutput hmacGetSecret;
    @JsonIgnore
    private Map<Class<? extends T>, T> extensions;

    @JsonAnySetter
    private void setUnknowns(@NonNull String name, @Nullable Object value) {
        this.unknowns.put(name, value);
    }

    @JsonAnyGetter
    private @NonNull Map<String, Object> getUnknowns() {
        return this.unknowns;
    }

    @JsonIgnore
    public @NonNull Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.appid != null) {
            keys.add("appid");
        }
        if (this.uvm != null) {
            keys.add("uvm");
        }
        if (this.credProps != null) {
            keys.add("credProps");
        }
        if (this.hmacCreateSecret != null) {
            keys.add("hmacCreateSecret");
        }
        if (this.hmacGetSecret != null) {
            keys.add("hmacGetSecret");
        }
        keys.addAll(this.getUnknownKeys());
        return keys;
    }

    @JsonIgnore
    public @NonNull Set<String> getUnknownKeys() {
        return this.unknowns.keySet();
    }

    @JsonIgnore
    public @Nullable Object getValue(@NonNull String key) {
        switch (key) {
            case "appid": {
                return this.appid;
            }
            case "uvm": {
                return this.uvm;
            }
            case "credProps": {
                return this.credProps;
            }
            case "hmacCreateSecret": {
                return this.hmacCreateSecret;
            }
            case "hmacGetSecret": {
                return this.hmacGetSecret;
            }
        }
        return this.unknowns.get(key);
    }

    @JsonIgnore
    public @Nullable Boolean getAppid() {
        return this.appid;
    }

    @JsonIgnore
    public @Nullable UvmEntries getUvm() {
        return this.uvm;
    }

    @JsonIgnore
    public @Nullable Boolean getHMACCreateSecret() {
        return this.hmacCreateSecret;
    }

    @JsonIgnore
    public @Nullable HMACGetSecretOutput getHMACGetSecret() {
        return this.hmacGetSecret;
    }

    @JsonIgnore
    public @Nullable CredentialPropertiesOutput getCredProps() {
        return this.credProps;
    }

    public <E extends T> @Nullable E getExtension(@NonNull Class<E> tClass) {
        return (E)((ExtensionClientOutput)this.getExtensions().get(tClass));
    }

    @JsonIgnore
    public @NonNull Map<Class<? extends T>, T> getExtensions() {
        if (this.extensions == null) {
            HashMap<Class<HMACSecretAuthenticationExtensionClientOutput>, SingleValueExtensionOutputBase> map = new HashMap<Class<HMACSecretAuthenticationExtensionClientOutput>, SingleValueExtensionOutputBase>();
            if (this.appid != null) {
                map.put(FIDOAppIDExtensionClientOutput.class, new FIDOAppIDExtensionClientOutput(this.appid));
            }
            if (this.uvm != null) {
                map.put(UserVerificationMethodExtensionClientOutput.class, new UserVerificationMethodExtensionClientOutput(this.uvm));
            }
            if (this.credProps != null) {
                map.put(CredentialPropertiesExtensionClientOutput.class, new CredentialPropertiesExtensionClientOutput(this.credProps));
            }
            if (this.hmacCreateSecret != null) {
                map.put(HMACSecretRegistrationExtensionClientOutput.class, new HMACSecretRegistrationExtensionClientOutput(this.hmacCreateSecret));
            }
            if (this.hmacGetSecret != null) {
                map.put(HMACSecretAuthenticationExtensionClientOutput.class, new HMACSecretAuthenticationExtensionClientOutput(this.hmacGetSecret));
            }
            this.extensions = Collections.unmodifiableMap(map);
        }
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationExtensionsClientOutputs that = (AuthenticationExtensionsClientOutputs)o;
        return Objects.equals(this.unknowns, that.unknowns) && Objects.equals(this.appid, that.appid) && Objects.equals(this.uvm, that.uvm) && Objects.equals(this.credProps, that.credProps) && Objects.equals(this.hmacCreateSecret, that.hmacCreateSecret) && Objects.equals(this.hmacGetSecret, that.hmacGetSecret) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.unknowns, this.appid, this.uvm, this.credProps, this.hmacCreateSecret, this.hmacGetSecret, this.extensions);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticationExtensionsAuthenticatorInputs(");
        String entries = this.getExtensions().values().stream().map(t -> String.format("%s=%s", t.getIdentifier(), t)).collect(Collectors.joining(", "));
        builder.append(entries);
        String unknownsStr = this.getUnknowns().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        if (!unknownsStr.isEmpty()) {
            builder.append(", ");
            builder.append(unknownsStr);
        }
        builder.append(")");
        return builder.toString();
    }

    public static class BuilderForAuthentication {
        private final Map<String, Object> unknowns = new HashMap<String, Object>();
        private Boolean appid;
        private UvmEntries uvm;
        private HMACGetSecretOutput hmacGetSecret;

        public @NonNull AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> build() {
            AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> instance = new AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput>();
            instance.appid = this.appid;
            instance.uvm = this.uvm;
            instance.hmacGetSecret = this.hmacGetSecret;
            instance.unknowns.putAll(this.unknowns);
            return instance;
        }

        public @NonNull BuilderForAuthentication setAppid(@Nullable Boolean appid) {
            this.appid = appid;
            return this;
        }

        public @NonNull BuilderForAuthentication setUvm(@Nullable UvmEntries uvm) {
            this.uvm = uvm;
            return this;
        }

        public @NonNull BuilderForAuthentication setHMACGetSecret(@Nullable HMACGetSecretOutput hmacGetSecret) {
            this.hmacGetSecret = hmacGetSecret;
            return this;
        }

        public @NonNull BuilderForAuthentication set(@NonNull String key, @Nullable Object value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }

    public static class BuilderForRegistration {
        private final Map<String, Object> unknowns = new HashMap<String, Object>();
        private UvmEntries uvm;
        private CredentialPropertiesOutput credProps;
        private Boolean hmacCreateSecret;

        public @NonNull AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> build() {
            AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> instance = new AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput>();
            instance.uvm = this.uvm;
            instance.credProps = this.credProps;
            instance.hmacCreateSecret = this.hmacCreateSecret;
            instance.unknowns.putAll(this.unknowns);
            return instance;
        }

        public @NonNull BuilderForRegistration setUvm(@Nullable UvmEntries uvm) {
            this.uvm = uvm;
            return this;
        }

        public @NonNull BuilderForRegistration setCredProps(@Nullable CredentialPropertiesOutput credProps) {
            this.credProps = credProps;
            return this;
        }

        public @NonNull BuilderForRegistration setHMACCreateSecret(@Nullable Boolean hmacCreateSecret) {
            this.hmacCreateSecret = hmacCreateSecret;
            return this;
        }

        public @NonNull BuilderForRegistration set(@NonNull String key, @Nullable Object value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }
}

