/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMGenerated;
import com.webauthn4j.data.attestation.statement.TPMISTAttest;
import com.webauthn4j.data.attestation.statement.TPMSClockInfo;
import com.webauthn4j.data.attestation.statement.TPMUAttest;
import com.webauthn4j.data.attestation.statement.TPMUtil;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TPMSAttest {
    private final TPMGenerated magic;
    private final TPMISTAttest type;
    private final byte[] qualifiedSigner;
    private final byte[] extraData;
    private final TPMSClockInfo clockInfo;
    private final BigInteger firmwareVersion;
    private final TPMUAttest attested;

    public TPMSAttest(@NonNull TPMGenerated magic, @NonNull TPMISTAttest type, @NonNull byte[] qualifiedSigner, @NonNull byte[] extraData, @NonNull TPMSClockInfo clockInfo, @NonNull BigInteger firmwareVersion, @NonNull TPMUAttest attested) {
        this.magic = magic;
        this.type = type;
        this.qualifiedSigner = qualifiedSigner;
        this.extraData = extraData;
        this.clockInfo = clockInfo;
        this.firmwareVersion = firmwareVersion;
        this.attested = attested;
    }

    public @NonNull TPMGenerated getMagic() {
        return this.magic;
    }

    public @NonNull TPMISTAttest getType() {
        return this.type;
    }

    public @NonNull byte[] getQualifiedSigner() {
        return ArrayUtil.clone((byte[])this.qualifiedSigner);
    }

    public @NonNull byte[] getExtraData() {
        return ArrayUtil.clone((byte[])this.extraData);
    }

    public @NonNull TPMSClockInfo getClockInfo() {
        return this.clockInfo;
    }

    public @NonNull BigInteger getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public @NonNull TPMUAttest getAttested() {
        return this.attested;
    }

    public @NonNull byte[] getBytes() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(this.getMagic().getValue());
            stream.write(this.getType().getValue());
            TPMUtil.writeSizedArray(stream, this.getQualifiedSigner());
            TPMUtil.writeSizedArray(stream, this.getExtraData());
            stream.write(this.getClockInfo().getBytes());
            stream.write(UnsignedNumberUtil.toBytes((BigInteger)this.getFirmwareVersion()));
            stream.write(this.getAttested().getBytes());
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMSAttest that = (TPMSAttest)o;
        return this.magic == that.magic && this.type == that.type && Arrays.equals(this.qualifiedSigner, that.qualifiedSigner) && Arrays.equals(this.extraData, that.extraData) && Objects.equals(this.clockInfo, that.clockInfo) && Objects.equals(this.firmwareVersion, that.firmwareVersion) && Objects.equals(this.attested, that.attested);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.magic, this.type, this.clockInfo, this.firmwareVersion, this.attested});
        result = 31 * result + Arrays.hashCode(this.qualifiedSigner);
        result = 31 * result + Arrays.hashCode(this.extraData);
        return result;
    }
}

