/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.AssertUtil;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CoreRegistrationParameters {
    private final CoreServerProperty serverProperty;
    private final List<PublicKeyCredentialParameters> pubKeyCredParams;
    private final boolean userVerificationRequired;
    private final boolean userPresenceRequired;

    public CoreRegistrationParameters(@NonNull CoreServerProperty serverProperty, @Nullable List<PublicKeyCredentialParameters> pubKeyCredParams, boolean userVerificationRequired, boolean userPresenceRequired) {
        AssertUtil.notNull((Object)serverProperty, (String)"serverProperty must not be null");
        this.serverProperty = serverProperty;
        this.pubKeyCredParams = pubKeyCredParams;
        this.userVerificationRequired = userVerificationRequired;
        this.userPresenceRequired = userPresenceRequired;
    }

    public CoreRegistrationParameters(@NonNull CoreServerProperty serverProperty, @Nullable List<PublicKeyCredentialParameters> pubKeyCredParams, boolean userVerificationRequired) {
        this(serverProperty, pubKeyCredParams, userVerificationRequired, true);
    }

    @Deprecated
    public CoreRegistrationParameters(@NonNull CoreServerProperty serverProperty, boolean userVerificationRequired, boolean userPresenceRequired) {
        this(serverProperty, null, userVerificationRequired, userPresenceRequired);
    }

    @Deprecated
    public CoreRegistrationParameters(@NonNull CoreServerProperty serverProperty, boolean userVerificationRequired) {
        this(serverProperty, null, userVerificationRequired, true);
    }

    public @NonNull CoreServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public @Nullable List<PublicKeyCredentialParameters> getPubKeyCredParams() {
        return this.pubKeyCredParams;
    }

    public boolean isUserVerificationRequired() {
        return this.userVerificationRequired;
    }

    public boolean isUserPresenceRequired() {
        return this.userPresenceRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreRegistrationParameters that = (CoreRegistrationParameters)o;
        return this.userVerificationRequired == that.userVerificationRequired && this.userPresenceRequired == that.userPresenceRequired && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.pubKeyCredParams, that.pubKeyCredParams);
    }

    public int hashCode() {
        return Objects.hash(this.serverProperty, this.pubKeyCredParams, this.userVerificationRequired, this.userPresenceRequired);
    }

    public String toString() {
        return "CoreRegistrationParameters(serverProperty=" + this.serverProperty + ", pubKeyCredParams=" + this.pubKeyCredParams + ", userVerificationRequired=" + this.userVerificationRequired + ", userPresenceRequired=" + this.userPresenceRequired + ")";
    }
}

